/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.Subnet;
import software.amazon.awssdk.services.dax.model.SubnetListCopier;
import software.amazon.awssdk.services.dax.transform.SubnetGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubnetGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, SubnetGroup> {
    private final String subnetGroupName;
    private final String description;
    private final String vpcId;
    private final List<Subnet> subnets;

    private SubnetGroup(BuilderImpl builder) {
        this.subnetGroupName = builder.subnetGroupName;
        this.description = builder.description;
        this.vpcId = builder.vpcId;
        this.subnets = builder.subnets;
    }

    public String subnetGroupName() {
        return this.subnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetGroup)) {
            return false;
        }
        SubnetGroup other = (SubnetGroup)obj;
        return Objects.equals(this.subnetGroupName(), other.subnetGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnets(), other.subnets());
    }

    public String toString() {
        return ToString.builder((String)"SubnetGroup").add("SubnetGroupName", (Object)this.subnetGroupName()).add("Description", (Object)this.description()).add("VpcId", (Object)this.vpcId()).add("Subnets", this.subnets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetGroupName": {
                return Optional.of(clazz.cast(this.subnetGroupName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "Subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubnetGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetGroupName;
        private String description;
        private String vpcId;
        private List<Subnet> subnets;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetGroup model) {
            this.subnetGroupName(model.subnetGroupName);
            this.description(model.description);
            this.vpcId(model.vpcId);
            this.subnets(model.subnets);
        }

        public final String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<Subnet.Builder> getSubnets() {
            return this.subnets != null ? (Collection)this.subnets.stream().map(Subnet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        public SubnetGroup build() {
            return new SubnetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubnetGroup> {
        public Builder subnetGroupName(String var1);

        public Builder description(String var1);

        public Builder vpcId(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);
    }
}

