/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.transform.SecurityGroupMembershipMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SecurityGroupMembership
implements StructuredPojo,
ToCopyableBuilder<Builder, SecurityGroupMembership> {
    private final String securityGroupIdentifier;
    private final String status;

    private SecurityGroupMembership(BuilderImpl builder) {
        this.securityGroupIdentifier = builder.securityGroupIdentifier;
        this.status = builder.status;
    }

    public String securityGroupIdentifier() {
        return this.securityGroupIdentifier;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupMembership)) {
            return false;
        }
        SecurityGroupMembership other = (SecurityGroupMembership)obj;
        return Objects.equals(this.securityGroupIdentifier(), other.securityGroupIdentifier()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"SecurityGroupMembership").add("SecurityGroupIdentifier", (Object)this.securityGroupIdentifier()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupIdentifier": {
                return Optional.of(clazz.cast(this.securityGroupIdentifier()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityGroupMembershipMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String securityGroupIdentifier;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupMembership model) {
            this.securityGroupIdentifier(model.securityGroupIdentifier);
            this.status(model.status);
        }

        public final String getSecurityGroupIdentifier() {
            return this.securityGroupIdentifier;
        }

        @Override
        public final Builder securityGroupIdentifier(String securityGroupIdentifier) {
            this.securityGroupIdentifier = securityGroupIdentifier;
            return this;
        }

        public final void setSecurityGroupIdentifier(String securityGroupIdentifier) {
            this.securityGroupIdentifier = securityGroupIdentifier;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public SecurityGroupMembership build() {
            return new SecurityGroupMembership(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SecurityGroupMembership> {
        public Builder securityGroupIdentifier(String var1);

        public Builder status(String var1);
    }
}

