/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dax.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.dax.model.DAXRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IncreaseReplicationFactorRequest
extends DAXRequest
implements ToCopyableBuilder<Builder, IncreaseReplicationFactorRequest> {
    private final String clusterName;
    private final Integer newReplicationFactor;
    private final List<String> availabilityZones;

    private IncreaseReplicationFactorRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.newReplicationFactor = builder.newReplicationFactor;
        this.availabilityZones = builder.availabilityZones;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public Integer newReplicationFactor() {
        return this.newReplicationFactor;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newReplicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseReplicationFactorRequest)) {
            return false;
        }
        IncreaseReplicationFactorRequest other = (IncreaseReplicationFactorRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.newReplicationFactor(), other.newReplicationFactor()) && Objects.equals(this.availabilityZones(), other.availabilityZones());
    }

    public String toString() {
        return ToString.builder((String)"IncreaseReplicationFactorRequest").add("ClusterName", (Object)this.clusterName()).add("NewReplicationFactor", (Object)this.newReplicationFactor()).add("AvailabilityZones", this.availabilityZones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.of(clazz.cast(this.clusterName()));
            }
            case "NewReplicationFactor": {
                return Optional.of(clazz.cast(this.newReplicationFactor()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DAXRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private Integer newReplicationFactor;
        private List<String> availabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseReplicationFactorRequest model) {
            this.clusterName(model.clusterName);
            this.newReplicationFactor(model.newReplicationFactor);
            this.availabilityZones(model.availabilityZones);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Integer getNewReplicationFactor() {
            return this.newReplicationFactor;
        }

        @Override
        public final Builder newReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
            return this;
        }

        public final void setNewReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public IncreaseReplicationFactorRequest build() {
            return new IncreaseReplicationFactorRequest(this);
        }
    }

    public static interface Builder
    extends DAXRequest.Builder,
    CopyableBuilder<Builder, IncreaseReplicationFactorRequest> {
        public Builder clusterName(String var1);

        public Builder newReplicationFactor(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

