/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dax.model.DAXRequest;
import software.amazon.awssdk.services.dax.model.SubnetGroupNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSubnetGroupsRequest
extends DAXRequest
implements ToCopyableBuilder<Builder, DescribeSubnetGroupsRequest> {
    private final List<String> subnetGroupNames;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeSubnetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.subnetGroupNames = builder.subnetGroupNames;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> subnetGroupNames() {
        return this.subnetGroupNames;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetGroupsRequest)) {
            return false;
        }
        DescribeSubnetGroupsRequest other = (DescribeSubnetGroupsRequest)((Object)obj);
        return Objects.equals(this.subnetGroupNames(), other.subnetGroupNames()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subnetGroupNames() != null) {
            sb.append("SubnetGroupNames: ").append(this.subnetGroupNames()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetGroupNames": {
                return Optional.of(clazz.cast(this.subnetGroupNames()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DAXRequest.BuilderImpl
    implements Builder {
        private List<String> subnetGroupNames;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetGroupsRequest model) {
            this.subnetGroupNames(model.subnetGroupNames);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getSubnetGroupNames() {
            return this.subnetGroupNames;
        }

        @Override
        public final Builder subnetGroupNames(Collection<String> subnetGroupNames) {
            this.subnetGroupNames = SubnetGroupNameListCopier.copy(subnetGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroupNames(String ... subnetGroupNames) {
            this.subnetGroupNames(Arrays.asList(subnetGroupNames));
            return this;
        }

        public final void setSubnetGroupNames(Collection<String> subnetGroupNames) {
            this.subnetGroupNames = SubnetGroupNameListCopier.copy(subnetGroupNames);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeSubnetGroupsRequest build() {
            return new DescribeSubnetGroupsRequest(this);
        }
    }

    public static interface Builder
    extends DAXRequest.Builder,
    CopyableBuilder<Builder, DescribeSubnetGroupsRequest> {
        public Builder subnetGroupNames(Collection<String> var1);

        public Builder subnetGroupNames(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

