/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.SubnetGroup;

@SdkInternalApi
public class SubnetGroupMarshaller {
    private static final MarshallingInfo<String> SUBNETGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroupName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subnets").build();
    private static final SubnetGroupMarshaller INSTANCE = new SubnetGroupMarshaller();

    public static SubnetGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SubnetGroup subnetGroup, ProtocolMarshaller protocolMarshaller) {
        if (subnetGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)subnetGroup.subnetGroupName(), SUBNETGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)subnetGroup.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)subnetGroup.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(subnetGroup.subnets(), SUBNETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

