/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dax.model.ParameterNameValue;
import software.amazon.awssdk.services.dax.model.ParameterNameValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateParameterGroupRequest> {
    private final String parameterGroupName;
    private final List<ParameterNameValue> parameterNameValues;

    private UpdateParameterGroupRequest(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterNameValues = builder.parameterNameValues;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public List<ParameterNameValue> parameterNameValues() {
        return this.parameterNameValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterGroupName() == null ? 0 : this.parameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.parameterNameValues() == null ? 0 : this.parameterNameValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParameterGroupRequest)) {
            return false;
        }
        UpdateParameterGroupRequest other = (UpdateParameterGroupRequest)((Object)obj);
        if (other.parameterGroupName() == null ^ this.parameterGroupName() == null) {
            return false;
        }
        if (other.parameterGroupName() != null && !other.parameterGroupName().equals(this.parameterGroupName())) {
            return false;
        }
        if (other.parameterNameValues() == null ^ this.parameterNameValues() == null) {
            return false;
        }
        return other.parameterNameValues() == null || other.parameterNameValues().equals(this.parameterNameValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterGroupName() != null) {
            sb.append("ParameterGroupName: ").append(this.parameterGroupName()).append(",");
        }
        if (this.parameterNameValues() != null) {
            sb.append("ParameterNameValues: ").append(this.parameterNameValues()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupName": {
                return Optional.of(clazz.cast(this.parameterGroupName()));
            }
            case "ParameterNameValues": {
                return Optional.of(clazz.cast(this.parameterNameValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private List<ParameterNameValue> parameterNameValues;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParameterGroupRequest model) {
            this.parameterGroupName(model.parameterGroupName);
            this.parameterNameValues(model.parameterNameValues);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final Collection<ParameterNameValue.Builder> getParameterNameValues() {
            return this.parameterNameValues != null ? (Collection)this.parameterNameValues.stream().map(ParameterNameValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue ... parameterNameValues) {
            this.parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        public UpdateParameterGroupRequest build() {
            return new UpdateParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateParameterGroupRequest> {
        public Builder parameterGroupName(String var1);

        public Builder parameterNameValues(Collection<ParameterNameValue> var1);

        public Builder parameterNameValues(ParameterNameValue ... var1);
    }
}

