/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dax.model.Node;
import software.amazon.awssdk.services.dax.transform.EndpointUnmarshaller;

public class NodeUnmarshaller
implements Unmarshaller<Node, JsonUnmarshallerContext> {
    private static final NodeUnmarshaller INSTANCE = new NodeUnmarshaller();

    public Node unmarshall(JsonUnmarshallerContext context) throws Exception {
        Node.Builder nodeBuilder = Node.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NodeId", targetDepth)) {
                    context.nextToken();
                    nodeBuilder.nodeId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    context.nextToken();
                    nodeBuilder.endpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("NodeCreateTime", targetDepth)) {
                    context.nextToken();
                    nodeBuilder.nodeCreateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    context.nextToken();
                    nodeBuilder.availabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NodeStatus", targetDepth)) {
                    context.nextToken();
                    nodeBuilder.nodeStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ParameterGroupStatus", targetDepth)) {
                    context.nextToken();
                    nodeBuilder.parameterGroupStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Node)nodeBuilder.build();
    }

    public static NodeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

