/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dax.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IncreaseReplicationFactorRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, IncreaseReplicationFactorRequest> {
    private final String clusterName;
    private final Integer newReplicationFactor;
    private final List<String> availabilityZones;

    private IncreaseReplicationFactorRequest(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.newReplicationFactor = builder.newReplicationFactor;
        this.availabilityZones = builder.availabilityZones;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public Integer newReplicationFactor() {
        return this.newReplicationFactor;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterName() == null ? 0 : this.clusterName().hashCode());
        hashCode = 31 * hashCode + (this.newReplicationFactor() == null ? 0 : this.newReplicationFactor().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseReplicationFactorRequest)) {
            return false;
        }
        IncreaseReplicationFactorRequest other = (IncreaseReplicationFactorRequest)((Object)obj);
        if (other.clusterName() == null ^ this.clusterName() == null) {
            return false;
        }
        if (other.clusterName() != null && !other.clusterName().equals(this.clusterName())) {
            return false;
        }
        if (other.newReplicationFactor() == null ^ this.newReplicationFactor() == null) {
            return false;
        }
        if (other.newReplicationFactor() != null && !other.newReplicationFactor().equals(this.newReplicationFactor())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        return other.availabilityZones() == null || other.availabilityZones().equals(this.availabilityZones());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterName() != null) {
            sb.append("ClusterName: ").append(this.clusterName()).append(",");
        }
        if (this.newReplicationFactor() != null) {
            sb.append("NewReplicationFactor: ").append(this.newReplicationFactor()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private Integer newReplicationFactor;
        private List<String> availabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseReplicationFactorRequest model) {
            this.setClusterName(model.clusterName);
            this.setNewReplicationFactor(model.newReplicationFactor);
            this.setAvailabilityZones(model.availabilityZones);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Integer getNewReplicationFactor() {
            return this.newReplicationFactor;
        }

        @Override
        public final Builder newReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
            return this;
        }

        public final void setNewReplicationFactor(Integer newReplicationFactor) {
            this.newReplicationFactor = newReplicationFactor;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        public IncreaseReplicationFactorRequest build() {
            return new IncreaseReplicationFactorRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IncreaseReplicationFactorRequest> {
        public Builder clusterName(String var1);

        public Builder newReplicationFactor(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);
    }
}

