/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dax.DAXClient;
import software.amazon.awssdk.services.dax.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.ClusterNotFoundException;
import software.amazon.awssdk.services.dax.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.dax.model.CreateClusterRequest;
import software.amazon.awssdk.services.dax.model.CreateClusterResponse;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DAXException;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.DeleteClusterRequest;
import software.amazon.awssdk.services.dax.model.DeleteClusterResponse;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DescribeClustersRequest;
import software.amazon.awssdk.services.dax.model.DescribeClustersResponse;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeEventsRequest;
import software.amazon.awssdk.services.dax.model.DescribeEventsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.dax.model.InvalidARNException;
import software.amazon.awssdk.services.dax.model.InvalidClusterStateException;
import software.amazon.awssdk.services.dax.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.dax.model.InvalidParameterGroupStateException;
import software.amazon.awssdk.services.dax.model.InvalidParameterValueException;
import software.amazon.awssdk.services.dax.model.InvalidSubnetException;
import software.amazon.awssdk.services.dax.model.InvalidVPCNetworkStateException;
import software.amazon.awssdk.services.dax.model.ListTagsRequest;
import software.amazon.awssdk.services.dax.model.ListTagsResponse;
import software.amazon.awssdk.services.dax.model.NodeNotFoundException;
import software.amazon.awssdk.services.dax.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.dax.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.dax.model.ParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.ParameterGroupNotFoundException;
import software.amazon.awssdk.services.dax.model.ParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.dax.model.RebootNodeRequest;
import software.amazon.awssdk.services.dax.model.RebootNodeResponse;
import software.amazon.awssdk.services.dax.model.SubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.SubnetGroupInUseException;
import software.amazon.awssdk.services.dax.model.SubnetGroupNotFoundException;
import software.amazon.awssdk.services.dax.model.SubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.dax.model.SubnetInUseException;
import software.amazon.awssdk.services.dax.model.SubnetQuotaExceededException;
import software.amazon.awssdk.services.dax.model.TagNotFoundException;
import software.amazon.awssdk.services.dax.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.dax.model.TagResourceRequest;
import software.amazon.awssdk.services.dax.model.TagResourceResponse;
import software.amazon.awssdk.services.dax.model.UntagResourceRequest;
import software.amazon.awssdk.services.dax.model.UntagResourceResponse;
import software.amazon.awssdk.services.dax.model.UpdateClusterRequest;
import software.amazon.awssdk.services.dax.model.UpdateClusterResponse;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.CreateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateParameterGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.CreateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateSubnetGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DecreaseReplicationFactorRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DecreaseReplicationFactorResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteClusterResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteParameterGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteSubnetGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeClustersResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeDefaultParametersResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeEventsResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParameterGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParametersResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeSubnetGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.IncreaseReplicationFactorRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.IncreaseReplicationFactorResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.ListTagsResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.RebootNodeRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.RebootNodeResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateParameterGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateSubnetGroupResponseUnmarshaller;

@SdkInternalApi
final class DefaultDAXClient
implements DAXClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultDAXClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ClusterAlreadyExistsException, InvalidClusterStateException, InsufficientClusterCapacityException, SubnetGroupNotFoundException, InvalidParameterGroupStateException, ParameterGroupNotFoundException, ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, InvalidVPCNetworkStateException, TagQuotaPerResourceExceededException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateClusterResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateClusterResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createClusterRequest).withMarshaller((Marshaller)new CreateClusterRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateParameterGroupResponse createParameterGroup(CreateParameterGroupRequest createParameterGroupRequest) throws ParameterGroupQuotaExceededException, ParameterGroupAlreadyExistsException, InvalidParameterGroupStateException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateParameterGroupResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateParameterGroupResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createParameterGroupRequest).withMarshaller((Marshaller)new CreateParameterGroupRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateSubnetGroupResponse createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) throws SubnetGroupAlreadyExistsException, SubnetGroupQuotaExceededException, SubnetQuotaExceededException, InvalidSubnetException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateSubnetGroupResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateSubnetGroupResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createSubnetGroupRequest).withMarshaller((Marshaller)new CreateSubnetGroupRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DecreaseReplicationFactorResponse decreaseReplicationFactor(DecreaseReplicationFactorRequest decreaseReplicationFactorRequest) throws ClusterNotFoundException, NodeNotFoundException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DecreaseReplicationFactorResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DecreaseReplicationFactorResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)decreaseReplicationFactorRequest).withMarshaller((Marshaller)new DecreaseReplicationFactorRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ClusterNotFoundException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteClusterResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteClusterResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteClusterRequest).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteParameterGroupResponse deleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest) throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteParameterGroupResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteParameterGroupResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteParameterGroupRequest).withMarshaller((Marshaller)new DeleteParameterGroupRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteSubnetGroupResponse deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) throws SubnetGroupInUseException, SubnetGroupNotFoundException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteSubnetGroupResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteSubnetGroupResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteSubnetGroupRequest).withMarshaller((Marshaller)new DeleteSubnetGroupRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeClustersResponse describeClusters() throws ClusterNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        return this.describeClusters((DescribeClustersRequest)((Object)DescribeClustersRequest.builder().build()));
    }

    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest) throws ClusterNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeClustersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeClustersResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeClustersRequest).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeDefaultParametersResponse describeDefaultParameters() throws InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        return this.describeDefaultParameters((DescribeDefaultParametersRequest)((Object)DescribeDefaultParametersRequest.builder().build()));
    }

    @Override
    public DescribeDefaultParametersResponse describeDefaultParameters(DescribeDefaultParametersRequest describeDefaultParametersRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeDefaultParametersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeDefaultParametersResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeDefaultParametersRequest).withMarshaller((Marshaller)new DescribeDefaultParametersRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeEventsResponse describeEvents() throws InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        return this.describeEvents((DescribeEventsRequest)((Object)DescribeEventsRequest.builder().build()));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeEventsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEventsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeParameterGroupsResponse describeParameterGroups() throws ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        return this.describeParameterGroups((DescribeParameterGroupsRequest)((Object)DescribeParameterGroupsRequest.builder().build()));
    }

    @Override
    public DescribeParameterGroupsResponse describeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest) throws ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeParameterGroupsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeParameterGroupsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeParameterGroupsRequest).withMarshaller((Marshaller)new DescribeParameterGroupsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest) throws ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeParametersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeParametersResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeParametersRequest).withMarshaller((Marshaller)new DescribeParametersRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeSubnetGroupsResponse describeSubnetGroups() throws SubnetGroupNotFoundException, SdkBaseException, SdkClientException, DAXException {
        return this.describeSubnetGroups((DescribeSubnetGroupsRequest)((Object)DescribeSubnetGroupsRequest.builder().build()));
    }

    @Override
    public DescribeSubnetGroupsResponse describeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest) throws SubnetGroupNotFoundException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeSubnetGroupsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeSubnetGroupsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeSubnetGroupsRequest).withMarshaller((Marshaller)new DescribeSubnetGroupsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public IncreaseReplicationFactorResponse increaseReplicationFactor(IncreaseReplicationFactorRequest increaseReplicationFactorRequest) throws ClusterNotFoundException, InvalidClusterStateException, InsufficientClusterCapacityException, InvalidVPCNetworkStateException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new IncreaseReplicationFactorResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (IncreaseReplicationFactorResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)increaseReplicationFactorRequest).withMarshaller((Marshaller)new IncreaseReplicationFactorRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ClusterNotFoundException, InvalidARNException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listTagsRequest).withMarshaller((Marshaller)new ListTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RebootNodeResponse rebootNode(RebootNodeRequest rebootNodeRequest) throws ClusterNotFoundException, NodeNotFoundException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RebootNodeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RebootNodeResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)rebootNodeRequest).withMarshaller((Marshaller)new RebootNodeRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ClusterNotFoundException, TagQuotaPerResourceExceededException, InvalidARNException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new TagResourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TagResourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ClusterNotFoundException, InvalidARNException, TagNotFoundException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UntagResourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UntagResourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws InvalidClusterStateException, ClusterNotFoundException, InvalidParameterGroupStateException, ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateClusterResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateClusterResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateClusterRequest).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateParameterGroupResponse updateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest) throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateParameterGroupResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateParameterGroupResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateParameterGroupRequest).withMarshaller((Marshaller)new UpdateParameterGroupRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateSubnetGroupResponse updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) throws SubnetGroupNotFoundException, SubnetQuotaExceededException, SubnetInUseException, InvalidSubnetException, SdkBaseException, SdkClientException, DAXException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateSubnetGroupResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateSubnetGroupResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateSubnetGroupRequest).withMarshaller((Marshaller)new UpdateSubnetGroupRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(DAXException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetQuotaExceededFault").withModeledClass(SubnetQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupNotFoundFault").withModeledClass(SubnetGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupQuotaExceededFault").withModeledClass(SubnetGroupQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidVPCNetworkStateFault").withModeledClass(InvalidVPCNetworkStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupAlreadyExistsFault").withModeledClass(ParameterGroupAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetInUse").withModeledClass(SubnetInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterNotFoundFault").withModeledClass(ClusterNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeNotFoundFault").withModeledClass(NodeNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterCombinationException").withModeledClass(InvalidParameterCombinationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeQuotaForCustomerExceededFault").withModeledClass(NodeQuotaForCustomerExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClusterStateFault").withModeledClass(InvalidClusterStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientClusterCapacityFault").withModeledClass(InsufficientClusterCapacityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagNotFoundFault").withModeledClass(TagNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidARNFault").withModeledClass(InvalidARNException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagQuotaPerResourceExceeded").withModeledClass(TagQuotaPerResourceExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterQuotaForCustomerExceededFault").withModeledClass(ClusterQuotaForCustomerExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupInUseFault").withModeledClass(SubnetGroupInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterGroupStateFault").withModeledClass(InvalidParameterGroupStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupNotFoundFault").withModeledClass(ParameterGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSubnet").withModeledClass(InvalidSubnetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterAlreadyExistsFault").withModeledClass(ClusterAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeQuotaForClusterExceededFault").withModeledClass(NodeQuotaForClusterExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupQuotaExceededFault").withModeledClass(ParameterGroupQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupAlreadyExistsFault").withModeledClass(SubnetGroupAlreadyExistsException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

