/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.transform.CreateSubnetGroupRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateSubnetGroupRequest>, CreateSubnetGroupRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AmazonDAXV3.CreateSubnetGroup").serviceName("Amazon DAX").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public CreateSubnetGroupRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateSubnetGroupRequest> marshall(CreateSubnetGroupRequest createSubnetGroupRequest) {
        Validate.paramNotNull((Object)((Object)createSubnetGroupRequest), (String)"createSubnetGroupRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)createSubnetGroupRequest);
            protocolMarshaller.startMarshalling();
            CreateSubnetGroupRequestModelMarshaller.getInstance().marshall(createSubnetGroupRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

