/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.transform.SubnetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subnet
implements StructuredPojo,
ToCopyableBuilder<Builder, Subnet> {
    private final String subnetIdentifier;
    private final String subnetAvailabilityZone;

    private Subnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
    }

    public String subnetIdentifier() {
        return this.subnetIdentifier;
    }

    public String subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.subnetIdentifier(), other.subnetIdentifier()) && Objects.equals(this.subnetAvailabilityZone(), other.subnetAvailabilityZone());
    }

    public String toString() {
        return ToString.builder((String)"Subnet").add("SubnetIdentifier", (Object)this.subnetIdentifier()).add("SubnetAvailabilityZone", (Object)this.subnetAvailabilityZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.subnetIdentifier()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.subnetAvailabilityZone()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubnetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetIdentifier;
        private String subnetAvailabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.subnetIdentifier(model.subnetIdentifier);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
        }

        public final String getSubnetIdentifier() {
            return this.subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        public final String getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        public Subnet build() {
            return new Subnet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subnet> {
        public Builder subnetIdentifier(String var1);

        public Builder subnetAvailabilityZone(String var1);
    }
}

