/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.Cluster;
import software.amazon.awssdk.services.dax.model.ClusterListCopier;
import software.amazon.awssdk.services.dax.model.DaxResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClustersResponse
extends DaxResponse
implements ToCopyableBuilder<Builder, DescribeClustersResponse> {
    private final String nextToken;
    private final List<Cluster> clusters;

    private DescribeClustersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.clusters = builder.clusters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<Cluster> clusters() {
        return this.clusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResponse)) {
            return false;
        }
        DescribeClustersResponse other = (DescribeClustersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.clusters(), other.clusters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClustersResponse").add("NextToken", (Object)this.nextToken()).add("Clusters", this.clusters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DaxResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Cluster> clusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.clusters(model.clusters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Cluster.Builder> getClusters() {
            return this.clusters != null ? (Collection)this.clusters.stream().map(Cluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusters(Collection<Cluster> clusters) {
            this.clusters = ClusterListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Cluster ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<Cluster.Builder> ... clusters) {
            this.clusters(Stream.of(clusters).map(c -> (Cluster)((Cluster.Builder)Cluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusters(Collection<Cluster.BuilderImpl> clusters) {
            this.clusters = ClusterListCopier.copyFromBuilder(clusters);
        }

        @Override
        public DescribeClustersResponse build() {
            return new DescribeClustersResponse(this);
        }
    }

    public static interface Builder
    extends DaxResponse.Builder,
    CopyableBuilder<Builder, DescribeClustersResponse> {
        public Builder nextToken(String var1);

        public Builder clusters(Collection<Cluster> var1);

        public Builder clusters(Cluster ... var1);

        public Builder clusters(Consumer<Cluster.Builder> ... var1);
    }
}

