/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.DaxRequest;
import software.amazon.awssdk.services.dax.model.ParameterNameValue;
import software.amazon.awssdk.services.dax.model.ParameterNameValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateParameterGroupRequest
extends DaxRequest
implements ToCopyableBuilder<Builder, UpdateParameterGroupRequest> {
    private final String parameterGroupName;
    private final List<ParameterNameValue> parameterNameValues;

    private UpdateParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterNameValues = builder.parameterNameValues;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public List<ParameterNameValue> parameterNameValues() {
        return this.parameterNameValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterNameValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParameterGroupRequest)) {
            return false;
        }
        UpdateParameterGroupRequest other = (UpdateParameterGroupRequest)((Object)obj);
        return Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.parameterNameValues(), other.parameterNameValues());
    }

    public String toString() {
        return ToString.builder((String)"UpdateParameterGroupRequest").add("ParameterGroupName", (Object)this.parameterGroupName()).add("ParameterNameValues", this.parameterNameValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "ParameterNameValues": {
                return Optional.ofNullable(clazz.cast(this.parameterNameValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DaxRequest.BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private List<ParameterNameValue> parameterNameValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParameterGroupRequest model) {
            super(model);
            this.parameterGroupName(model.parameterGroupName);
            this.parameterNameValues(model.parameterNameValues);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final Collection<ParameterNameValue.Builder> getParameterNameValues() {
            return this.parameterNameValues != null ? (Collection)this.parameterNameValues.stream().map(ParameterNameValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue ... parameterNameValues) {
            this.parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(Consumer<ParameterNameValue.Builder> ... parameterNameValues) {
            this.parameterNameValues(Stream.of(parameterNameValues).map(c -> (ParameterNameValue)((ParameterNameValue.Builder)ParameterNameValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateParameterGroupRequest build() {
            return new UpdateParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends DaxRequest.Builder,
    CopyableBuilder<Builder, UpdateParameterGroupRequest> {
        public Builder parameterGroupName(String var1);

        public Builder parameterNameValues(Collection<ParameterNameValue> var1);

        public Builder parameterNameValues(ParameterNameValue ... var1);

        public Builder parameterNameValues(Consumer<ParameterNameValue.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

