/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.DaxRequest;
import software.amazon.awssdk.services.dax.model.SubnetGroupNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSubnetGroupsRequest
extends DaxRequest
implements ToCopyableBuilder<Builder, DescribeSubnetGroupsRequest> {
    private final List<String> subnetGroupNames;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeSubnetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.subnetGroupNames = builder.subnetGroupNames;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> subnetGroupNames() {
        return this.subnetGroupNames;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetGroupsRequest)) {
            return false;
        }
        DescribeSubnetGroupsRequest other = (DescribeSubnetGroupsRequest)((Object)obj);
        return Objects.equals(this.subnetGroupNames(), other.subnetGroupNames()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSubnetGroupsRequest").add("SubnetGroupNames", this.subnetGroupNames()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetGroupNames": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupNames()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DaxRequest.BuilderImpl
    implements Builder {
        private List<String> subnetGroupNames = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetGroupsRequest model) {
            super(model);
            this.subnetGroupNames(model.subnetGroupNames);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getSubnetGroupNames() {
            return this.subnetGroupNames;
        }

        @Override
        public final Builder subnetGroupNames(Collection<String> subnetGroupNames) {
            this.subnetGroupNames = SubnetGroupNameListCopier.copy(subnetGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetGroupNames(String ... subnetGroupNames) {
            this.subnetGroupNames(Arrays.asList(subnetGroupNames));
            return this;
        }

        public final void setSubnetGroupNames(Collection<String> subnetGroupNames) {
            this.subnetGroupNames = SubnetGroupNameListCopier.copy(subnetGroupNames);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSubnetGroupsRequest build() {
            return new DescribeSubnetGroupsRequest(this);
        }
    }

    public static interface Builder
    extends DaxRequest.Builder,
    CopyableBuilder<Builder, DescribeSubnetGroupsRequest> {
        public Builder subnetGroupNames(Collection<String> var1);

        public Builder subnetGroupNames(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

