/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dax.DaxClient;
import software.amazon.awssdk.services.dax.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.ClusterNotFoundException;
import software.amazon.awssdk.services.dax.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.dax.model.CreateClusterRequest;
import software.amazon.awssdk.services.dax.model.CreateClusterResponse;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DaxException;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.DecreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.DeleteClusterRequest;
import software.amazon.awssdk.services.dax.model.DeleteClusterResponse;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.dax.model.DescribeClustersRequest;
import software.amazon.awssdk.services.dax.model.DescribeClustersResponse;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeDefaultParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeEventsRequest;
import software.amazon.awssdk.services.dax.model.DescribeEventsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.dax.model.DescribeParametersRequest;
import software.amazon.awssdk.services.dax.model.DescribeParametersResponse;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.dax.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorRequest;
import software.amazon.awssdk.services.dax.model.IncreaseReplicationFactorResponse;
import software.amazon.awssdk.services.dax.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.dax.model.InvalidArnException;
import software.amazon.awssdk.services.dax.model.InvalidClusterStateException;
import software.amazon.awssdk.services.dax.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.dax.model.InvalidParameterGroupStateException;
import software.amazon.awssdk.services.dax.model.InvalidParameterValueException;
import software.amazon.awssdk.services.dax.model.InvalidSubnetException;
import software.amazon.awssdk.services.dax.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.dax.model.ListTagsRequest;
import software.amazon.awssdk.services.dax.model.ListTagsResponse;
import software.amazon.awssdk.services.dax.model.NodeNotFoundException;
import software.amazon.awssdk.services.dax.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.dax.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.dax.model.ParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.ParameterGroupNotFoundException;
import software.amazon.awssdk.services.dax.model.ParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.dax.model.RebootNodeRequest;
import software.amazon.awssdk.services.dax.model.RebootNodeResponse;
import software.amazon.awssdk.services.dax.model.SubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.dax.model.SubnetGroupInUseException;
import software.amazon.awssdk.services.dax.model.SubnetGroupNotFoundException;
import software.amazon.awssdk.services.dax.model.SubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.dax.model.SubnetInUseException;
import software.amazon.awssdk.services.dax.model.SubnetQuotaExceededException;
import software.amazon.awssdk.services.dax.model.TagNotFoundException;
import software.amazon.awssdk.services.dax.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.dax.model.TagResourceRequest;
import software.amazon.awssdk.services.dax.model.TagResourceResponse;
import software.amazon.awssdk.services.dax.model.UntagResourceRequest;
import software.amazon.awssdk.services.dax.model.UntagResourceResponse;
import software.amazon.awssdk.services.dax.model.UpdateClusterRequest;
import software.amazon.awssdk.services.dax.model.UpdateClusterResponse;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.dax.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.dax.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.CreateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateParameterGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.CreateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.CreateSubnetGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DecreaseReplicationFactorRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DecreaseReplicationFactorResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteClusterResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteParameterGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DeleteSubnetGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeClustersResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeDefaultParametersResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeEventsResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParameterGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeParametersResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.DescribeSubnetGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.IncreaseReplicationFactorRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.IncreaseReplicationFactorResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.ListTagsResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.RebootNodeRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.RebootNodeResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateParameterGroupResponseUnmarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.dax.transform.UpdateSubnetGroupResponseUnmarshaller;

@SdkInternalApi
final class DefaultDaxClient
implements DaxClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDaxClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "dax";
    }

    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ClusterAlreadyExistsException, InvalidClusterStateException, InsufficientClusterCapacityException, SubnetGroupNotFoundException, InvalidParameterGroupStateException, ParameterGroupNotFoundException, ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, InvalidVpcNetworkStateException, TagQuotaPerResourceExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateClusterResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterRequest).withMarshaller((Marshaller)new CreateClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateParameterGroupResponse createParameterGroup(CreateParameterGroupRequest createParameterGroupRequest) throws ParameterGroupQuotaExceededException, ParameterGroupAlreadyExistsException, InvalidParameterGroupStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateParameterGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createParameterGroupRequest).withMarshaller((Marshaller)new CreateParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateSubnetGroupResponse createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) throws SubnetGroupAlreadyExistsException, SubnetGroupQuotaExceededException, SubnetQuotaExceededException, InvalidSubnetException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSubnetGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSubnetGroupRequest).withMarshaller((Marshaller)new CreateSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DecreaseReplicationFactorResponse decreaseReplicationFactor(DecreaseReplicationFactorRequest decreaseReplicationFactorRequest) throws ClusterNotFoundException, NodeNotFoundException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DecreaseReplicationFactorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DecreaseReplicationFactorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)decreaseReplicationFactorRequest).withMarshaller((Marshaller)new DecreaseReplicationFactorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ClusterNotFoundException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteClusterResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterRequest).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteParameterGroupResponse deleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest) throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteParameterGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteParameterGroupRequest).withMarshaller((Marshaller)new DeleteParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSubnetGroupResponse deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) throws SubnetGroupInUseException, SubnetGroupNotFoundException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSubnetGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSubnetGroupRequest).withMarshaller((Marshaller)new DeleteSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest) throws ClusterNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClustersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClustersRequest).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDefaultParametersResponse describeDefaultParameters(DescribeDefaultParametersRequest describeDefaultParametersRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDefaultParametersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeDefaultParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDefaultParametersRequest).withMarshaller((Marshaller)new DescribeDefaultParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeParameterGroupsResponse describeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest) throws ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeParameterGroupsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeParameterGroupsRequest).withMarshaller((Marshaller)new DescribeParameterGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest) throws ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeParametersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeParametersRequest).withMarshaller((Marshaller)new DescribeParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeSubnetGroupsResponse describeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest) throws SubnetGroupNotFoundException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSubnetGroupsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSubnetGroupsRequest).withMarshaller((Marshaller)new DescribeSubnetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public IncreaseReplicationFactorResponse increaseReplicationFactor(IncreaseReplicationFactorRequest increaseReplicationFactorRequest) throws ClusterNotFoundException, InvalidClusterStateException, InsufficientClusterCapacityException, InvalidVpcNetworkStateException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new IncreaseReplicationFactorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (IncreaseReplicationFactorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)increaseReplicationFactorRequest).withMarshaller((Marshaller)new IncreaseReplicationFactorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ClusterNotFoundException, InvalidArnException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest).withMarshaller((Marshaller)new ListTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RebootNodeResponse rebootNode(RebootNodeRequest rebootNodeRequest) throws ClusterNotFoundException, NodeNotFoundException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RebootNodeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RebootNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootNodeRequest).withMarshaller((Marshaller)new RebootNodeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ClusterNotFoundException, TagQuotaPerResourceExceededException, InvalidArnException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ClusterNotFoundException, InvalidArnException, TagNotFoundException, InvalidClusterStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws InvalidClusterStateException, ClusterNotFoundException, InvalidParameterGroupStateException, ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateClusterResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateClusterRequest).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateParameterGroupResponse updateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest) throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateParameterGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateParameterGroupRequest).withMarshaller((Marshaller)new UpdateParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateSubnetGroupResponse updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) throws SubnetGroupNotFoundException, SubnetQuotaExceededException, SubnetInUseException, InvalidSubnetException, AwsServiceException, SdkClientException, DaxException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSubnetGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSubnetGroupRequest).withMarshaller((Marshaller)new UpdateSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(DaxException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetQuotaExceededFault").withModeledClass(SubnetQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupNotFoundFault").withModeledClass(SubnetGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupQuotaExceededFault").withModeledClass(SubnetGroupQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupAlreadyExistsFault").withModeledClass(ParameterGroupAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetInUse").withModeledClass(SubnetInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterNotFoundFault").withModeledClass(ClusterNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeNotFoundFault").withModeledClass(NodeNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidARNFault").withModeledClass(InvalidArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterCombinationException").withModeledClass(InvalidParameterCombinationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeQuotaForCustomerExceededFault").withModeledClass(NodeQuotaForCustomerExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClusterStateFault").withModeledClass(InvalidClusterStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientClusterCapacityFault").withModeledClass(InsufficientClusterCapacityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagNotFoundFault").withModeledClass(TagNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidVPCNetworkStateFault").withModeledClass(InvalidVpcNetworkStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagQuotaPerResourceExceeded").withModeledClass(TagQuotaPerResourceExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterQuotaForCustomerExceededFault").withModeledClass(ClusterQuotaForCustomerExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupInUseFault").withModeledClass(SubnetGroupInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterGroupStateFault").withModeledClass(InvalidParameterGroupStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupNotFoundFault").withModeledClass(ParameterGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSubnet").withModeledClass(InvalidSubnetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterAlreadyExistsFault").withModeledClass(ClusterAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NodeQuotaForClusterExceededFault").withModeledClass(NodeQuotaForClusterExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParameterGroupQuotaExceededFault").withModeledClass(ParameterGroupQuotaExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetGroupAlreadyExistsFault").withModeledClass(SubnetGroupAlreadyExistsException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

