/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dax.model.ParameterGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParameterGroupMarshaller {
    private static final MarshallingInfo<String> PARAMETERGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final ParameterGroupMarshaller INSTANCE = new ParameterGroupMarshaller();

    private ParameterGroupMarshaller() {
    }

    public static ParameterGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ParameterGroup parameterGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parameterGroup, (String)"parameterGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parameterGroup.parameterGroupName(), PARAMETERGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)parameterGroup.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

