/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.Cluster;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClusterMarshaller {
    private static final MarshallingInfo<String> CLUSTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterArn").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOTALNODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalNodes").isBinary(false).build();
    private static final MarshallingInfo<Integer> ACTIVENODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveNodes").isBinary(false).build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CLUSTERDISCOVERYENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterDiscoveryEndpoint").isBinary(false).build();
    private static final MarshallingInfo<List> NODEIDSTOREMOVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeIdsToRemove").isBinary(false).build();
    private static final MarshallingInfo<List> NODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Nodes").isBinary(false).build();
    private static final MarshallingInfo<String> PREFERREDMAINTENANCEWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreferredMaintenanceWindow").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroup").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroups").isBinary(false).build();
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARAMETERGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroup").isBinary(false).build();
    private static final ClusterMarshaller INSTANCE = new ClusterMarshaller();

    private ClusterMarshaller() {
    }

    public static ClusterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Cluster cluster, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cluster, (String)"cluster");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cluster.clusterName(), CLUSTERNAME_BINDING);
            protocolMarshaller.marshall((Object)cluster.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)cluster.clusterArn(), CLUSTERARN_BINDING);
            protocolMarshaller.marshall((Object)cluster.totalNodes(), TOTALNODES_BINDING);
            protocolMarshaller.marshall((Object)cluster.activeNodes(), ACTIVENODES_BINDING);
            protocolMarshaller.marshall((Object)cluster.nodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)cluster.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)cluster.clusterDiscoveryEndpoint(), CLUSTERDISCOVERYENDPOINT_BINDING);
            protocolMarshaller.marshall(cluster.nodeIdsToRemove(), NODEIDSTOREMOVE_BINDING);
            protocolMarshaller.marshall(cluster.nodes(), NODES_BINDING);
            protocolMarshaller.marshall((Object)cluster.preferredMaintenanceWindow(), PREFERREDMAINTENANCEWINDOW_BINDING);
            protocolMarshaller.marshall((Object)cluster.notificationConfiguration(), NOTIFICATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)cluster.subnetGroup(), SUBNETGROUP_BINDING);
            protocolMarshaller.marshall(cluster.securityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)cluster.iamRoleArn(), IAMROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cluster.parameterGroup(), PARAMETERGROUP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

