/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dax.model.SourceType;
import software.amazon.awssdk.services.dax.transform.EventMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Event
implements StructuredPojo,
ToCopyableBuilder<Builder, Event> {
    private final String sourceName;
    private final String sourceType;
    private final String message;
    private final Instant date;

    private Event(BuilderImpl builder) {
        this.sourceName = builder.sourceName;
        this.sourceType = builder.sourceType;
        this.message = builder.message;
        this.date = builder.date;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public String message() {
        return this.message;
    }

    public Instant date() {
        return this.date;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.date(), other.date());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("SourceName", (Object)this.sourceName()).add("SourceType", (Object)this.sourceTypeAsString()).add("Message", (Object)this.message()).add("Date", (Object)this.date()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceName": {
                return Optional.of(clazz.cast(this.sourceName()));
            }
            case "SourceType": {
                return Optional.of(clazz.cast(this.sourceTypeAsString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "Date": {
                return Optional.of(clazz.cast(this.date()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceName;
        private String sourceType;
        private String message;
        private Instant date;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.sourceName(model.sourceName);
            this.sourceType(model.sourceType);
            this.message(model.message);
            this.date(model.date);
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder sourceName(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder message(String var1);

        public Builder date(Instant var1);
    }
}

