/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.dax.model.DAXResponse;
import software.amazon.awssdk.services.dax.model.ParameterGroup;
import software.amazon.awssdk.services.dax.model.ParameterGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeParameterGroupsResponse
extends DAXResponse
implements ToCopyableBuilder<Builder, DescribeParameterGroupsResponse> {
    private final String nextToken;
    private final List<ParameterGroup> parameterGroups;

    private DescribeParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.parameterGroups = builder.parameterGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ParameterGroup> parameterGroups() {
        return this.parameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParameterGroupsResponse)) {
            return false;
        }
        DescribeParameterGroupsResponse other = (DescribeParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.parameterGroups(), other.parameterGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeParameterGroupsResponse").add("NextToken", (Object)this.nextToken()).add("ParameterGroups", this.parameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ParameterGroups": {
                return Optional.of(clazz.cast(this.parameterGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DAXResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ParameterGroup> parameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParameterGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.parameterGroups(model.parameterGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ParameterGroup.Builder> getParameterGroups() {
            return this.parameterGroups != null ? (Collection)this.parameterGroups.stream().map(ParameterGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterGroups(Collection<ParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ParameterGroup ... parameterGroups) {
            this.parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(Consumer<ParameterGroup.Builder> ... parameterGroups) {
            this.parameterGroups(Stream.of(parameterGroups).map(c -> (ParameterGroup)((ParameterGroup.Builder)ParameterGroup.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterGroups(Collection<ParameterGroup.BuilderImpl> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copyFromBuilder(parameterGroups);
        }

        @Override
        public DescribeParameterGroupsResponse build() {
            return new DescribeParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends DAXResponse.Builder,
    CopyableBuilder<Builder, DescribeParameterGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder parameterGroups(Collection<ParameterGroup> var1);

        public Builder parameterGroups(ParameterGroup ... var1);

        public Builder parameterGroups(Consumer<ParameterGroup.Builder> ... var1);
    }
}

