/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage;
import software.amazon.awssdk.services.datazone.model.DataSourceRunLineageSummary;
import software.amazon.awssdk.services.datazone.model.DataSourceRunStatus;
import software.amazon.awssdk.services.datazone.model.DataSourceRunType;
import software.amazon.awssdk.services.datazone.model.RunStatisticsForAssets;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceRunSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceRunSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DataSourceRunSummary.getter(DataSourceRunSummary::createdAt)).setter(DataSourceRunSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(DataSourceRunSummary.getter(DataSourceRunSummary::dataSourceId)).setter(DataSourceRunSummary.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()}).build();
    private static final SdkField<DataSourceErrorMessage> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorMessage").getter(DataSourceRunSummary.getter(DataSourceRunSummary::errorMessage)).setter(DataSourceRunSummary.setter(Builder::errorMessage)).constructor(DataSourceErrorMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DataSourceRunSummary.getter(DataSourceRunSummary::id)).setter(DataSourceRunSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<DataSourceRunLineageSummary> LINEAGE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lineageSummary").getter(DataSourceRunSummary.getter(DataSourceRunSummary::lineageSummary)).setter(DataSourceRunSummary.setter(Builder::lineageSummary)).constructor(DataSourceRunLineageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageSummary").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(DataSourceRunSummary.getter(DataSourceRunSummary::projectId)).setter(DataSourceRunSummary.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<RunStatisticsForAssets> RUN_STATISTICS_FOR_ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runStatisticsForAssets").getter(DataSourceRunSummary.getter(DataSourceRunSummary::runStatisticsForAssets)).setter(DataSourceRunSummary.setter(Builder::runStatisticsForAssets)).constructor(RunStatisticsForAssets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStatisticsForAssets").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(DataSourceRunSummary.getter(DataSourceRunSummary::startedAt)).setter(DataSourceRunSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataSourceRunSummary.getter(DataSourceRunSummary::statusAsString)).setter(DataSourceRunSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stoppedAt").getter(DataSourceRunSummary.getter(DataSourceRunSummary::stoppedAt)).setter(DataSourceRunSummary.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DataSourceRunSummary.getter(DataSourceRunSummary::typeAsString)).setter(DataSourceRunSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(DataSourceRunSummary.getter(DataSourceRunSummary::updatedAt)).setter(DataSourceRunSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DATA_SOURCE_ID_FIELD, ERROR_MESSAGE_FIELD, ID_FIELD, LINEAGE_SUMMARY_FIELD, PROJECT_ID_FIELD, RUN_STATISTICS_FOR_ASSETS_FIELD, STARTED_AT_FIELD, STATUS_FIELD, STOPPED_AT_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceRunSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String dataSourceId;
    private final DataSourceErrorMessage errorMessage;
    private final String id;
    private final DataSourceRunLineageSummary lineageSummary;
    private final String projectId;
    private final RunStatisticsForAssets runStatisticsForAssets;
    private final Instant startedAt;
    private final String status;
    private final Instant stoppedAt;
    private final String type;
    private final Instant updatedAt;

    private DataSourceRunSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataSourceId = builder.dataSourceId;
        this.errorMessage = builder.errorMessage;
        this.id = builder.id;
        this.lineageSummary = builder.lineageSummary;
        this.projectId = builder.projectId;
        this.runStatisticsForAssets = builder.runStatisticsForAssets;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.stoppedAt = builder.stoppedAt;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final DataSourceErrorMessage errorMessage() {
        return this.errorMessage;
    }

    public final String id() {
        return this.id;
    }

    public final DataSourceRunLineageSummary lineageSummary() {
        return this.lineageSummary;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final RunStatisticsForAssets runStatisticsForAssets() {
        return this.runStatisticsForAssets;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final DataSourceRunStatus status() {
        return DataSourceRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant stoppedAt() {
        return this.stoppedAt;
    }

    public final DataSourceRunType type() {
        return DataSourceRunType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runStatisticsForAssets());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceRunSummary)) {
            return false;
        }
        DataSourceRunSummary other = (DataSourceRunSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lineageSummary(), other.lineageSummary()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.runStatisticsForAssets(), other.runStatisticsForAssets()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceRunSummary").add("CreatedAt", (Object)this.createdAt()).add("DataSourceId", (Object)this.dataSourceId()).add("ErrorMessage", (Object)this.errorMessage()).add("Id", (Object)this.id()).add("LineageSummary", (Object)this.lineageSummary()).add("ProjectId", (Object)this.projectId()).add("RunStatisticsForAssets", (Object)this.runStatisticsForAssets()).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).add("StoppedAt", (Object)this.stoppedAt()).add("Type", (Object)this.typeAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lineageSummary": {
                return Optional.ofNullable(clazz.cast(this.lineageSummary()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "runStatisticsForAssets": {
                return Optional.ofNullable(clazz.cast(this.runStatisticsForAssets()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("id", ID_FIELD);
        map.put("lineageSummary", LINEAGE_SUMMARY_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("runStatisticsForAssets", RUN_STATISTICS_FOR_ASSETS_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("stoppedAt", STOPPED_AT_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceRunSummary, T> g) {
        return obj -> g.apply((DataSourceRunSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String dataSourceId;
        private DataSourceErrorMessage errorMessage;
        private String id;
        private DataSourceRunLineageSummary lineageSummary;
        private String projectId;
        private RunStatisticsForAssets runStatisticsForAssets;
        private Instant startedAt;
        private String status;
        private Instant stoppedAt;
        private String type;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceRunSummary model) {
            this.createdAt(model.createdAt);
            this.dataSourceId(model.dataSourceId);
            this.errorMessage(model.errorMessage);
            this.id(model.id);
            this.lineageSummary(model.lineageSummary);
            this.projectId(model.projectId);
            this.runStatisticsForAssets(model.runStatisticsForAssets);
            this.startedAt(model.startedAt);
            this.status(model.status);
            this.stoppedAt(model.stoppedAt);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final DataSourceErrorMessage.Builder getErrorMessage() {
            return this.errorMessage != null ? this.errorMessage.toBuilder() : null;
        }

        public final void setErrorMessage(DataSourceErrorMessage.BuilderImpl errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage.build() : null;
        }

        @Override
        public final Builder errorMessage(DataSourceErrorMessage errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DataSourceRunLineageSummary.Builder getLineageSummary() {
            return this.lineageSummary != null ? this.lineageSummary.toBuilder() : null;
        }

        public final void setLineageSummary(DataSourceRunLineageSummary.BuilderImpl lineageSummary) {
            this.lineageSummary = lineageSummary != null ? lineageSummary.build() : null;
        }

        @Override
        public final Builder lineageSummary(DataSourceRunLineageSummary lineageSummary) {
            this.lineageSummary = lineageSummary;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final RunStatisticsForAssets.Builder getRunStatisticsForAssets() {
            return this.runStatisticsForAssets != null ? this.runStatisticsForAssets.toBuilder() : null;
        }

        public final void setRunStatisticsForAssets(RunStatisticsForAssets.BuilderImpl runStatisticsForAssets) {
            this.runStatisticsForAssets = runStatisticsForAssets != null ? runStatisticsForAssets.build() : null;
        }

        @Override
        public final Builder runStatisticsForAssets(RunStatisticsForAssets runStatisticsForAssets) {
            this.runStatisticsForAssets = runStatisticsForAssets;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStoppedAt() {
            return this.stoppedAt;
        }

        public final void setStoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceRunType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public DataSourceRunSummary build() {
            return new DataSourceRunSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceRunSummary> {
        public Builder createdAt(Instant var1);

        public Builder dataSourceId(String var1);

        public Builder errorMessage(DataSourceErrorMessage var1);

        default public Builder errorMessage(Consumer<DataSourceErrorMessage.Builder> errorMessage) {
            return this.errorMessage((DataSourceErrorMessage)((DataSourceErrorMessage.Builder)DataSourceErrorMessage.builder().applyMutation(errorMessage)).build());
        }

        public Builder id(String var1);

        public Builder lineageSummary(DataSourceRunLineageSummary var1);

        default public Builder lineageSummary(Consumer<DataSourceRunLineageSummary.Builder> lineageSummary) {
            return this.lineageSummary((DataSourceRunLineageSummary)((DataSourceRunLineageSummary.Builder)DataSourceRunLineageSummary.builder().applyMutation(lineageSummary)).build());
        }

        public Builder projectId(String var1);

        public Builder runStatisticsForAssets(RunStatisticsForAssets var1);

        default public Builder runStatisticsForAssets(Consumer<RunStatisticsForAssets.Builder> runStatisticsForAssets) {
            return this.runStatisticsForAssets((RunStatisticsForAssets)((RunStatisticsForAssets.Builder)RunStatisticsForAssets.builder().applyMutation(runStatisticsForAssets)).build());
        }

        public Builder startedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(DataSourceRunStatus var1);

        public Builder stoppedAt(Instant var1);

        public Builder type(String var1);

        public Builder type(DataSourceRunType var1);

        public Builder updatedAt(Instant var1);
    }
}

