/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user policy grant principal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPolicyGrantPrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPolicyGrantPrincipal.Builder, UserPolicyGrantPrincipal> {
    private static final SdkField<AllUsersGrantFilter> ALL_USERS_GRANT_FILTER_FIELD = SdkField
            .<AllUsersGrantFilter> builder(MarshallingType.SDK_POJO).memberName("allUsersGrantFilter")
            .getter(getter(UserPolicyGrantPrincipal::allUsersGrantFilter)).setter(setter(Builder::allUsersGrantFilter))
            .constructor(AllUsersGrantFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allUsersGrantFilter").build())
            .build();

    private static final SdkField<String> USER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userIdentifier").getter(getter(UserPolicyGrantPrincipal::userIdentifier))
            .setter(setter(Builder::userIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_USERS_GRANT_FILTER_FIELD,
            USER_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AllUsersGrantFilter allUsersGrantFilter;

    private final String userIdentifier;

    private final Type type;

    private UserPolicyGrantPrincipal(BuilderImpl builder) {
        this.allUsersGrantFilter = builder.allUsersGrantFilter;
        this.userIdentifier = builder.userIdentifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * The all users grant filter of the user policy grant principal.
     * </p>
     * 
     * @return The all users grant filter of the user policy grant principal.
     */
    public final AllUsersGrantFilter allUsersGrantFilter() {
        return allUsersGrantFilter;
    }

    /**
     * <p>
     * The user ID of the user policy grant principal.
     * </p>
     * 
     * @return The user ID of the user policy grant principal.
     */
    public final String userIdentifier() {
        return userIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allUsersGrantFilter());
        hashCode = 31 * hashCode + Objects.hashCode(userIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPolicyGrantPrincipal)) {
            return false;
        }
        UserPolicyGrantPrincipal other = (UserPolicyGrantPrincipal) obj;
        return Objects.equals(allUsersGrantFilter(), other.allUsersGrantFilter())
                && Objects.equals(userIdentifier(), other.userIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPolicyGrantPrincipal").add("AllUsersGrantFilter", allUsersGrantFilter())
                .add("UserIdentifier", userIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allUsersGrantFilter":
            return Optional.ofNullable(clazz.cast(allUsersGrantFilter()));
        case "userIdentifier":
            return Optional.ofNullable(clazz.cast(userIdentifier()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #allUsersGrantFilter()} initialized to the given value.
     *
     * <p>
     * The all users grant filter of the user policy grant principal.
     * </p>
     * 
     * @param allUsersGrantFilter
     *        The all users grant filter of the user policy grant principal.
     */
    public static UserPolicyGrantPrincipal fromAllUsersGrantFilter(AllUsersGrantFilter allUsersGrantFilter) {
        return builder().allUsersGrantFilter(allUsersGrantFilter).build();
    }

    /**
     * Create an instance of this class with {@link #allUsersGrantFilter()} initialized to the given value.
     *
     * <p>
     * The all users grant filter of the user policy grant principal.
     * </p>
     * 
     * @param allUsersGrantFilter
     *        The all users grant filter of the user policy grant principal.
     */
    public static UserPolicyGrantPrincipal fromAllUsersGrantFilter(Consumer<AllUsersGrantFilter.Builder> allUsersGrantFilter) {
        AllUsersGrantFilter.Builder builder = AllUsersGrantFilter.builder();
        allUsersGrantFilter.accept(builder);
        return fromAllUsersGrantFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #userIdentifier()} initialized to the given value.
     *
     * <p>
     * The user ID of the user policy grant principal.
     * </p>
     * 
     * @param userIdentifier
     *        The user ID of the user policy grant principal.
     */
    public static UserPolicyGrantPrincipal fromUserIdentifier(String userIdentifier) {
        return builder().userIdentifier(userIdentifier).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allUsersGrantFilter", ALL_USERS_GRANT_FILTER_FIELD);
        map.put("userIdentifier", USER_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPolicyGrantPrincipal, T> g) {
        return obj -> g.apply((UserPolicyGrantPrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPolicyGrantPrincipal> {
        /**
         * <p>
         * The all users grant filter of the user policy grant principal.
         * </p>
         * 
         * @param allUsersGrantFilter
         *        The all users grant filter of the user policy grant principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allUsersGrantFilter(AllUsersGrantFilter allUsersGrantFilter);

        /**
         * <p>
         * The all users grant filter of the user policy grant principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllUsersGrantFilter.Builder} avoiding the
         * need to create one manually via {@link AllUsersGrantFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllUsersGrantFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #allUsersGrantFilter(AllUsersGrantFilter)}.
         * 
         * @param allUsersGrantFilter
         *        a consumer that will call methods on {@link AllUsersGrantFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allUsersGrantFilter(AllUsersGrantFilter)
         */
        default Builder allUsersGrantFilter(Consumer<AllUsersGrantFilter.Builder> allUsersGrantFilter) {
            return allUsersGrantFilter(AllUsersGrantFilter.builder().applyMutation(allUsersGrantFilter).build());
        }

        /**
         * <p>
         * The user ID of the user policy grant principal.
         * </p>
         * 
         * @param userIdentifier
         *        The user ID of the user policy grant principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdentifier(String userIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private AllUsersGrantFilter allUsersGrantFilter;

        private String userIdentifier;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UserPolicyGrantPrincipal model) {
            allUsersGrantFilter(model.allUsersGrantFilter);
            userIdentifier(model.userIdentifier);
        }

        public final AllUsersGrantFilter.Builder getAllUsersGrantFilter() {
            return allUsersGrantFilter != null ? allUsersGrantFilter.toBuilder() : null;
        }

        public final void setAllUsersGrantFilter(AllUsersGrantFilter.BuilderImpl allUsersGrantFilter) {
            Object oldValue = this.allUsersGrantFilter;
            this.allUsersGrantFilter = allUsersGrantFilter != null ? allUsersGrantFilter.build() : null;
            handleUnionValueChange(Type.ALL_USERS_GRANT_FILTER, oldValue, this.allUsersGrantFilter);
        }

        @Override
        public final Builder allUsersGrantFilter(AllUsersGrantFilter allUsersGrantFilter) {
            Object oldValue = this.allUsersGrantFilter;
            this.allUsersGrantFilter = allUsersGrantFilter;
            handleUnionValueChange(Type.ALL_USERS_GRANT_FILTER, oldValue, this.allUsersGrantFilter);
            return this;
        }

        public final String getUserIdentifier() {
            return userIdentifier;
        }

        public final void setUserIdentifier(String userIdentifier) {
            Object oldValue = this.userIdentifier;
            this.userIdentifier = userIdentifier;
            handleUnionValueChange(Type.USER_IDENTIFIER, oldValue, this.userIdentifier);
        }

        @Override
        public final Builder userIdentifier(String userIdentifier) {
            Object oldValue = this.userIdentifier;
            this.userIdentifier = userIdentifier;
            handleUnionValueChange(Type.USER_IDENTIFIER, oldValue, this.userIdentifier);
            return this;
        }

        @Override
        public UserPolicyGrantPrincipal build() {
            return new UserPolicyGrantPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UserPolicyGrantPrincipal#type()
     */
    public enum Type {
        ALL_USERS_GRANT_FILTER,

        USER_IDENTIFIER,

        UNKNOWN_TO_SDK_VERSION
    }
}
