/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRootDomainUnitOwnerRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateRootDomainUnitOwnerRequest.Builder, UpdateRootDomainUnitOwnerRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateRootDomainUnitOwnerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CURRENT_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentOwner").getter(getter(UpdateRootDomainUnitOwnerRequest::currentOwner))
            .setter(setter(Builder::currentOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentOwner").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateRootDomainUnitOwnerRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> NEW_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newOwner").getter(getter(UpdateRootDomainUnitOwnerRequest::newOwner)).setter(setter(Builder::newOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CURRENT_OWNER_FIELD, DOMAIN_IDENTIFIER_FIELD, NEW_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String currentOwner;

    private final String domainIdentifier;

    private final String newOwner;

    private UpdateRootDomainUnitOwnerRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.currentOwner = builder.currentOwner;
        this.domainIdentifier = builder.domainIdentifier;
        this.newOwner = builder.newOwner;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated
     * if not provided.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
     *         populated if not provided.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The current owner of the root domain unit.
     * </p>
     * 
     * @return The current owner of the root domain unit.
     */
    public final String currentOwner() {
        return currentOwner;
    }

    /**
     * <p>
     * The ID of the domain where the root domain unit owner is to be updated.
     * </p>
     * 
     * @return The ID of the domain where the root domain unit owner is to be updated.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The new owner of the root domain unit.
     * </p>
     * 
     * @return The new owner of the root domain unit.
     */
    public final String newOwner() {
        return newOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(currentOwner());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(newOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRootDomainUnitOwnerRequest)) {
            return false;
        }
        UpdateRootDomainUnitOwnerRequest other = (UpdateRootDomainUnitOwnerRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(currentOwner(), other.currentOwner())
                && Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(newOwner(), other.newOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRootDomainUnitOwnerRequest").add("ClientToken", clientToken())
                .add("CurrentOwner", currentOwner()).add("DomainIdentifier", domainIdentifier()).add("NewOwner", newOwner())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "currentOwner":
            return Optional.ofNullable(clazz.cast(currentOwner()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "newOwner":
            return Optional.ofNullable(clazz.cast(newOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("currentOwner", CURRENT_OWNER_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("newOwner", NEW_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRootDomainUnitOwnerRequest, T> g) {
        return obj -> g.apply((UpdateRootDomainUnitOwnerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRootDomainUnitOwnerRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
         * populated if not provided.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically
         *        populated if not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The current owner of the root domain unit.
         * </p>
         * 
         * @param currentOwner
         *        The current owner of the root domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentOwner(String currentOwner);

        /**
         * <p>
         * The ID of the domain where the root domain unit owner is to be updated.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where the root domain unit owner is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The new owner of the root domain unit.
         * </p>
         * 
         * @param newOwner
         *        The new owner of the root domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newOwner(String newOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String currentOwner;

        private String domainIdentifier;

        private String newOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRootDomainUnitOwnerRequest model) {
            super(model);
            clientToken(model.clientToken);
            currentOwner(model.currentOwner);
            domainIdentifier(model.domainIdentifier);
            newOwner(model.newOwner);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCurrentOwner() {
            return currentOwner;
        }

        public final void setCurrentOwner(String currentOwner) {
            this.currentOwner = currentOwner;
        }

        @Override
        public final Builder currentOwner(String currentOwner) {
            this.currentOwner = currentOwner;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getNewOwner() {
            return newOwner;
        }

        public final void setNewOwner(String newOwner) {
            this.newOwner = newOwner;
        }

        @Override
        public final Builder newOwner(String newOwner) {
            this.newOwner = newOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRootDomainUnitOwnerRequest build() {
            return new UpdateRootDomainUnitOwnerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
