/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlossaryTermResponse extends DataZoneResponse implements
        ToCopyableBuilder<UpdateGlossaryTermResponse.Builder, UpdateGlossaryTermResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(UpdateGlossaryTermResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> GLOSSARY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glossaryId").getter(getter(UpdateGlossaryTermResponse::glossaryId)).setter(setter(Builder::glossaryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateGlossaryTermResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("longDescription").getter(getter(UpdateGlossaryTermResponse::longDescription))
            .setter(setter(Builder::longDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longDescription").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateGlossaryTermResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shortDescription").getter(getter(UpdateGlossaryTermResponse::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortDescription").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateGlossaryTermResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<TermRelations> TERM_RELATIONS_FIELD = SdkField
            .<TermRelations> builder(MarshallingType.SDK_POJO).memberName("termRelations")
            .getter(getter(UpdateGlossaryTermResponse::termRelations)).setter(setter(Builder::termRelations))
            .constructor(TermRelations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termRelations").build()).build();

    private static final SdkField<List<String>> USAGE_RESTRICTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("usageRestrictions")
            .getter(getter(UpdateGlossaryTermResponse::usageRestrictionsAsStrings))
            .setter(setter(Builder::usageRestrictionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageRestrictions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            GLOSSARY_ID_FIELD, ID_FIELD, LONG_DESCRIPTION_FIELD, NAME_FIELD, SHORT_DESCRIPTION_FIELD, STATUS_FIELD,
            TERM_RELATIONS_FIELD, USAGE_RESTRICTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainId;

    private final String glossaryId;

    private final String id;

    private final String longDescription;

    private final String name;

    private final String shortDescription;

    private final String status;

    private final TermRelations termRelations;

    private final List<String> usageRestrictions;

    private UpdateGlossaryTermResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.glossaryId = builder.glossaryId;
        this.id = builder.id;
        this.longDescription = builder.longDescription;
        this.name = builder.name;
        this.shortDescription = builder.shortDescription;
        this.status = builder.status;
        this.termRelations = builder.termRelations;
        this.usageRestrictions = builder.usageRestrictions;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which a business glossary term is to be updated.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which a business glossary term is to be updated.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The identifier of the business glossary in which a term is to be updated.
     * </p>
     * 
     * @return The identifier of the business glossary in which a term is to be updated.
     */
    public final String glossaryId() {
        return glossaryId;
    }

    /**
     * <p>
     * The identifier of the business glossary term that is to be updated.
     * </p>
     * 
     * @return The identifier of the business glossary term that is to be updated.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The long description to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     * </p>
     * 
     * @return The long description to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     */
    public final String longDescription() {
        return longDescription;
    }

    /**
     * <p>
     * The name to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     * </p>
     * 
     * @return The name to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The short description to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     * </p>
     * 
     * @return The short description to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    /**
     * <p>
     * The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryTermStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     * @see GlossaryTermStatus
     */
    public final GlossaryTermStatus status() {
        return GlossaryTermStatus.fromValue(status);
    }

    /**
     * <p>
     * The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryTermStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     * @see GlossaryTermStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The term relations to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     * </p>
     * 
     * @return The term relations to be updated as part of the <code>UpdateGlossaryTerm</code> action.
     */
    public final TermRelations termRelations() {
        return termRelations;
    }

    /**
     * <p>
     * The usage restriction of a term within a restricted glossary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageRestrictions} method.
     * </p>
     * 
     * @return The usage restriction of a term within a restricted glossary.
     */
    public final List<GlossaryUsageRestriction> usageRestrictions() {
        return GlossaryUsageRestrictionsCopier.copyStringToEnum(usageRestrictions);
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageRestrictions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsageRestrictions() {
        return usageRestrictions != null && !(usageRestrictions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage restriction of a term within a restricted glossary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageRestrictions} method.
     * </p>
     * 
     * @return The usage restriction of a term within a restricted glossary.
     */
    public final List<String> usageRestrictionsAsStrings() {
        return usageRestrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(glossaryId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termRelations());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageRestrictions() ? usageRestrictionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlossaryTermResponse)) {
            return false;
        }
        UpdateGlossaryTermResponse other = (UpdateGlossaryTermResponse) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(glossaryId(), other.glossaryId())
                && Objects.equals(id(), other.id()) && Objects.equals(longDescription(), other.longDescription())
                && Objects.equals(name(), other.name()) && Objects.equals(shortDescription(), other.shortDescription())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(termRelations(), other.termRelations())
                && hasUsageRestrictions() == other.hasUsageRestrictions()
                && Objects.equals(usageRestrictionsAsStrings(), other.usageRestrictionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGlossaryTermResponse").add("DomainId", domainId()).add("GlossaryId", glossaryId())
                .add("Id", id()).add("LongDescription", longDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShortDescription", shortDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("TermRelations", termRelations())
                .add("UsageRestrictions", hasUsageRestrictions() ? usageRestrictionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "glossaryId":
            return Optional.ofNullable(clazz.cast(glossaryId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "longDescription":
            return Optional.ofNullable(clazz.cast(longDescription()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "shortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "termRelations":
            return Optional.ofNullable(clazz.cast(termRelations()));
        case "usageRestrictions":
            return Optional.ofNullable(clazz.cast(usageRestrictionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("glossaryId", GLOSSARY_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("longDescription", LONG_DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("shortDescription", SHORT_DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("termRelations", TERM_RELATIONS_FIELD);
        map.put("usageRestrictions", USAGE_RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlossaryTermResponse, T> g) {
        return obj -> g.apply((UpdateGlossaryTermResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGlossaryTermResponse> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which a business glossary term is to be updated.
         * </p>
         * 
         * @param domainId
         *        The identifier of the Amazon DataZone domain in which a business glossary term is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The identifier of the business glossary in which a term is to be updated.
         * </p>
         * 
         * @param glossaryId
         *        The identifier of the business glossary in which a term is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryId(String glossaryId);

        /**
         * <p>
         * The identifier of the business glossary term that is to be updated.
         * </p>
         * 
         * @param id
         *        The identifier of the business glossary term that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The long description to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * </p>
         * 
         * @param longDescription
         *        The long description to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longDescription(String longDescription);

        /**
         * <p>
         * The name to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * </p>
         * 
         * @param name
         *        The name to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The short description to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * </p>
         * 
         * @param shortDescription
         *        The short description to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);

        /**
         * <p>
         * The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * </p>
         * 
         * @param status
         *        The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * @see GlossaryTermStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryTermStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * </p>
         * 
         * @param status
         *        The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * @see GlossaryTermStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryTermStatus
         */
        Builder status(GlossaryTermStatus status);

        /**
         * <p>
         * The term relations to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * </p>
         * 
         * @param termRelations
         *        The term relations to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termRelations(TermRelations termRelations);

        /**
         * <p>
         * The term relations to be updated as part of the <code>UpdateGlossaryTerm</code> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link TermRelations.Builder} avoiding the need
         * to create one manually via {@link TermRelations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TermRelations.Builder#build()} is called immediately and its
         * result is passed to {@link #termRelations(TermRelations)}.
         * 
         * @param termRelations
         *        a consumer that will call methods on {@link TermRelations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #termRelations(TermRelations)
         */
        default Builder termRelations(Consumer<TermRelations.Builder> termRelations) {
            return termRelations(TermRelations.builder().applyMutation(termRelations).build());
        }

        /**
         * <p>
         * The usage restriction of a term within a restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of a term within a restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictionsWithStrings(Collection<String> usageRestrictions);

        /**
         * <p>
         * The usage restriction of a term within a restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of a term within a restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictionsWithStrings(String... usageRestrictions);

        /**
         * <p>
         * The usage restriction of a term within a restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of a term within a restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictions(Collection<GlossaryUsageRestriction> usageRestrictions);

        /**
         * <p>
         * The usage restriction of a term within a restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of a term within a restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictions(GlossaryUsageRestriction... usageRestrictions);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String domainId;

        private String glossaryId;

        private String id;

        private String longDescription;

        private String name;

        private String shortDescription;

        private String status;

        private TermRelations termRelations;

        private List<String> usageRestrictions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlossaryTermResponse model) {
            super(model);
            domainId(model.domainId);
            glossaryId(model.glossaryId);
            id(model.id);
            longDescription(model.longDescription);
            name(model.name);
            shortDescription(model.shortDescription);
            status(model.status);
            termRelations(model.termRelations);
            usageRestrictionsWithStrings(model.usageRestrictions);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGlossaryId() {
            return glossaryId;
        }

        public final void setGlossaryId(String glossaryId) {
            this.glossaryId = glossaryId;
        }

        @Override
        public final Builder glossaryId(String glossaryId) {
            this.glossaryId = glossaryId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLongDescription() {
            return longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryTermStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TermRelations.Builder getTermRelations() {
            return termRelations != null ? termRelations.toBuilder() : null;
        }

        public final void setTermRelations(TermRelations.BuilderImpl termRelations) {
            this.termRelations = termRelations != null ? termRelations.build() : null;
        }

        @Override
        public final Builder termRelations(TermRelations termRelations) {
            this.termRelations = termRelations;
            return this;
        }

        public final Collection<String> getUsageRestrictions() {
            if (usageRestrictions instanceof SdkAutoConstructList) {
                return null;
            }
            return usageRestrictions;
        }

        public final void setUsageRestrictions(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
        }

        @Override
        public final Builder usageRestrictionsWithStrings(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictionsWithStrings(String... usageRestrictions) {
            usageRestrictionsWithStrings(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public final Builder usageRestrictions(Collection<GlossaryUsageRestriction> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copyEnumToString(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictions(GlossaryUsageRestriction... usageRestrictions) {
            usageRestrictions(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public UpdateGlossaryTermResponse build() {
            return new UpdateGlossaryTermResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
