/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the term relations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TermRelations implements SdkPojo, Serializable, ToCopyableBuilder<TermRelations.Builder, TermRelations> {
    private static final SdkField<List<String>> CLASSIFIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("classifies")
            .getter(getter(TermRelations::classifies))
            .setter(setter(Builder::classifies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ISA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("isA")
            .getter(getter(TermRelations::isA))
            .setter(setter(Builder::isA))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isA").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFIES_FIELD, ISA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> classifies;

    private final List<String> isA;

    private TermRelations(BuilderImpl builder) {
        this.classifies = builder.classifies;
        this.isA = builder.isA;
    }

    /**
     * For responses, this returns true if the service returned a value for the Classifies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClassifies() {
        return classifies != null && !(classifies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The classifies of the term relations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClassifies} method.
     * </p>
     * 
     * @return The classifies of the term relations.
     */
    public final List<String> classifies() {
        return classifies;
    }

    /**
     * For responses, this returns true if the service returned a value for the IsA property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIsA() {
        return isA != null && !(isA instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>isA</code> property of the term relations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIsA} method.
     * </p>
     * 
     * @return The <code>isA</code> property of the term relations.
     */
    public final List<String> isA() {
        return isA;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClassifies() ? classifies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIsA() ? isA() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermRelations)) {
            return false;
        }
        TermRelations other = (TermRelations) obj;
        return hasClassifies() == other.hasClassifies() && Objects.equals(classifies(), other.classifies())
                && hasIsA() == other.hasIsA() && Objects.equals(isA(), other.isA());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TermRelations").add("Classifies", hasClassifies() ? classifies() : null)
                .add("IsA", hasIsA() ? isA() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "classifies":
            return Optional.ofNullable(clazz.cast(classifies()));
        case "isA":
            return Optional.ofNullable(clazz.cast(isA()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("classifies", CLASSIFIES_FIELD);
        map.put("isA", ISA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TermRelations, T> g) {
        return obj -> g.apply((TermRelations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TermRelations> {
        /**
         * <p>
         * The classifies of the term relations.
         * </p>
         * 
         * @param classifies
         *        The classifies of the term relations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifies(Collection<String> classifies);

        /**
         * <p>
         * The classifies of the term relations.
         * </p>
         * 
         * @param classifies
         *        The classifies of the term relations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifies(String... classifies);

        /**
         * <p>
         * The <code>isA</code> property of the term relations.
         * </p>
         * 
         * @param isA
         *        The <code>isA</code> property of the term relations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isA(Collection<String> isA);

        /**
         * <p>
         * The <code>isA</code> property of the term relations.
         * </p>
         * 
         * @param isA
         *        The <code>isA</code> property of the term relations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isA(String... isA);
    }

    static final class BuilderImpl implements Builder {
        private List<String> classifies = DefaultSdkAutoConstructList.getInstance();

        private List<String> isA = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TermRelations model) {
            classifies(model.classifies);
            isA(model.isA);
        }

        public final Collection<String> getClassifies() {
            if (classifies instanceof SdkAutoConstructList) {
                return null;
            }
            return classifies;
        }

        public final void setClassifies(Collection<String> classifies) {
            this.classifies = TermRelationsClassifiesListCopier.copy(classifies);
        }

        @Override
        public final Builder classifies(Collection<String> classifies) {
            this.classifies = TermRelationsClassifiesListCopier.copy(classifies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifies(String... classifies) {
            classifies(Arrays.asList(classifies));
            return this;
        }

        public final Collection<String> getIsA() {
            if (isA instanceof SdkAutoConstructList) {
                return null;
            }
            return isA;
        }

        public final void setIsA(Collection<String> isA) {
            this.isA = TermRelationsIsAListCopier.copy(isA);
        }

        @Override
        public final Builder isA(Collection<String> isA) {
            this.isA = TermRelationsIsAListCopier.copy(isA);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isA(String... isA) {
            isA(Arrays.asList(isA));
            return this;
        }

        @Override
        public TermRelations build() {
            return new TermRelations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
