/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data product listing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedProductListing implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribedProductListing.Builder, SubscribedProductListing> {
    private static final SdkField<List<AssetInDataProductListingItem>> ASSET_LISTINGS_FIELD = SdkField
            .<List<AssetInDataProductListingItem>> builder(MarshallingType.LIST)
            .memberName("assetListings")
            .getter(getter(SubscribedProductListing::assetListings))
            .setter(setter(Builder::assetListings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetListings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetInDataProductListingItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetInDataProductListingItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SubscribedProductListing::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(SubscribedProductListing::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityRevision").getter(getter(SubscribedProductListing::entityRevision))
            .setter(setter(Builder::entityRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()).build();

    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<DetailedGlossaryTerm>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(SubscribedProductListing::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetailedGlossaryTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetailedGlossaryTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SubscribedProductListing::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_LISTINGS_FIELD,
            DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_REVISION_FIELD, GLOSSARY_TERMS_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AssetInDataProductListingItem> assetListings;

    private final String description;

    private final String entityId;

    private final String entityRevision;

    private final List<DetailedGlossaryTerm> glossaryTerms;

    private final String name;

    private SubscribedProductListing(BuilderImpl builder) {
        this.assetListings = builder.assetListings;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.glossaryTerms = builder.glossaryTerms;
        this.name = builder.name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetListings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetListings() {
        return assetListings != null && !(assetListings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data assets of the data product listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetListings} method.
     * </p>
     * 
     * @return The data assets of the data product listing.
     */
    public final List<AssetInDataProductListingItem> assetListings() {
        return assetListings;
    }

    /**
     * <p>
     * The description of the data product listing.
     * </p>
     * 
     * @return The description of the data product listing.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the data product listing.
     * </p>
     * 
     * @return The ID of the data product listing.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The revision of the data product listing.
     * </p>
     * 
     * @return The revision of the data product listing.
     */
    public final String entityRevision() {
        return entityRevision;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms of the data product listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms of the data product listing.
     */
    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The name of the data product listing.
     * </p>
     * 
     * @return The name of the data product listing.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetListings() ? assetListings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedProductListing)) {
            return false;
        }
        SubscribedProductListing other = (SubscribedProductListing) obj;
        return hasAssetListings() == other.hasAssetListings() && Objects.equals(assetListings(), other.assetListings())
                && Objects.equals(description(), other.description()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(entityRevision(), other.entityRevision()) && hasGlossaryTerms() == other.hasGlossaryTerms()
                && Objects.equals(glossaryTerms(), other.glossaryTerms()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedProductListing").add("AssetListings", hasAssetListings() ? assetListings() : null)
                .add("Description", description()).add("EntityId", entityId()).add("EntityRevision", entityRevision())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetListings":
            return Optional.ofNullable(clazz.cast(assetListings()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityRevision":
            return Optional.ofNullable(clazz.cast(entityRevision()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetListings", ASSET_LISTINGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityRevision", ENTITY_REVISION_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedProductListing, T> g) {
        return obj -> g.apply((SubscribedProductListing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedProductListing> {
        /**
         * <p>
         * The data assets of the data product listing.
         * </p>
         * 
         * @param assetListings
         *        The data assets of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetListings(Collection<AssetInDataProductListingItem> assetListings);

        /**
         * <p>
         * The data assets of the data product listing.
         * </p>
         * 
         * @param assetListings
         *        The data assets of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetListings(AssetInDataProductListingItem... assetListings);

        /**
         * <p>
         * The data assets of the data product listing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.AssetInDataProductListingItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.AssetInDataProductListingItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.AssetInDataProductListingItem.Builder#build()} is
         * called immediately and its result is passed to {@link #assetListings(List<AssetInDataProductListingItem>)}.
         * 
         * @param assetListings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.AssetInDataProductListingItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetListings(java.util.Collection<AssetInDataProductListingItem>)
         */
        Builder assetListings(Consumer<AssetInDataProductListingItem.Builder>... assetListings);

        /**
         * <p>
         * The description of the data product listing.
         * </p>
         * 
         * @param description
         *        The description of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the data product listing.
         * </p>
         * 
         * @param entityId
         *        The ID of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The revision of the data product listing.
         * </p>
         * 
         * @param entityRevision
         *        The revision of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRevision(String entityRevision);

        /**
         * <p>
         * The glossary terms of the data product listing.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms);

        /**
         * <p>
         * The glossary terms of the data product listing.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms);

        /**
         * <p>
         * The glossary terms of the data product listing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #glossaryTerms(List<DetailedGlossaryTerm>)}.
         * 
         * @param glossaryTerms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glossaryTerms(java.util.Collection<DetailedGlossaryTerm>)
         */
        Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms);

        /**
         * <p>
         * The name of the data product listing.
         * </p>
         * 
         * @param name
         *        The name of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private List<AssetInDataProductListingItem> assetListings = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String entityId;

        private String entityRevision;

        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedProductListing model) {
            assetListings(model.assetListings);
            description(model.description);
            entityId(model.entityId);
            entityRevision(model.entityRevision);
            glossaryTerms(model.glossaryTerms);
            name(model.name);
        }

        public final List<AssetInDataProductListingItem.Builder> getAssetListings() {
            List<AssetInDataProductListingItem.Builder> result = AssetInDataProductListingItemsCopier
                    .copyToBuilder(this.assetListings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetListings(Collection<AssetInDataProductListingItem.BuilderImpl> assetListings) {
            this.assetListings = AssetInDataProductListingItemsCopier.copyFromBuilder(assetListings);
        }

        @Override
        public final Builder assetListings(Collection<AssetInDataProductListingItem> assetListings) {
            this.assetListings = AssetInDataProductListingItemsCopier.copy(assetListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetListings(AssetInDataProductListingItem... assetListings) {
            assetListings(Arrays.asList(assetListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetListings(Consumer<AssetInDataProductListingItem.Builder>... assetListings) {
            assetListings(Stream.of(assetListings).map(c -> AssetInDataProductListingItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms) {
            glossaryTerms(Stream.of(glossaryTerms).map(c -> DetailedGlossaryTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SubscribedProductListing build() {
            return new SubscribedProductListing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
