/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Spark EMR properties patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SparkEmrPropertiesPatch implements SdkPojo, Serializable,
        ToCopyableBuilder<SparkEmrPropertiesPatch.Builder, SparkEmrPropertiesPatch> {
    private static final SdkField<String> COMPUTE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeArn").getter(getter(SparkEmrPropertiesPatch::computeArn)).setter(setter(Builder::computeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeArn").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceProfileArn").getter(getter(SparkEmrPropertiesPatch::instanceProfileArn))
            .setter(setter(Builder::instanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfileArn").build())
            .build();

    private static final SdkField<String> JAVA_VIRTUAL_ENV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("javaVirtualEnv").getter(getter(SparkEmrPropertiesPatch::javaVirtualEnv))
            .setter(setter(Builder::javaVirtualEnv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("javaVirtualEnv").build()).build();

    private static final SdkField<String> LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logUri")
            .getter(getter(SparkEmrPropertiesPatch::logUri)).setter(setter(Builder::logUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUri").build()).build();

    private static final SdkField<String> MANAGED_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedEndpointArn").getter(getter(SparkEmrPropertiesPatch::managedEndpointArn))
            .setter(setter(Builder::managedEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEndpointArn").build())
            .build();

    private static final SdkField<String> PYTHON_VIRTUAL_ENV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pythonVirtualEnv").getter(getter(SparkEmrPropertiesPatch::pythonVirtualEnv))
            .setter(setter(Builder::pythonVirtualEnv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pythonVirtualEnv").build()).build();

    private static final SdkField<String> RUNTIME_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runtimeRole").getter(getter(SparkEmrPropertiesPatch::runtimeRole)).setter(setter(Builder::runtimeRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeRole").build()).build();

    private static final SdkField<String> TRUSTED_CERTIFICATES_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustedCertificatesS3Uri").getter(getter(SparkEmrPropertiesPatch::trustedCertificatesS3Uri))
            .setter(setter(Builder::trustedCertificatesS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustedCertificatesS3Uri").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ARN_FIELD,
            INSTANCE_PROFILE_ARN_FIELD, JAVA_VIRTUAL_ENV_FIELD, LOG_URI_FIELD, MANAGED_ENDPOINT_ARN_FIELD,
            PYTHON_VIRTUAL_ENV_FIELD, RUNTIME_ROLE_FIELD, TRUSTED_CERTIFICATES_S3_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String computeArn;

    private final String instanceProfileArn;

    private final String javaVirtualEnv;

    private final String logUri;

    private final String managedEndpointArn;

    private final String pythonVirtualEnv;

    private final String runtimeRole;

    private final String trustedCertificatesS3Uri;

    private SparkEmrPropertiesPatch(BuilderImpl builder) {
        this.computeArn = builder.computeArn;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.javaVirtualEnv = builder.javaVirtualEnv;
        this.logUri = builder.logUri;
        this.managedEndpointArn = builder.managedEndpointArn;
        this.pythonVirtualEnv = builder.pythonVirtualEnv;
        this.runtimeRole = builder.runtimeRole;
        this.trustedCertificatesS3Uri = builder.trustedCertificatesS3Uri;
    }

    /**
     * <p>
     * The compute ARN in the Spark EMR properties patch.
     * </p>
     * 
     * @return The compute ARN in the Spark EMR properties patch.
     */
    public final String computeArn() {
        return computeArn;
    }

    /**
     * <p>
     * The instance profile ARN in the Spark EMR properties patch.
     * </p>
     * 
     * @return The instance profile ARN in the Spark EMR properties patch.
     */
    public final String instanceProfileArn() {
        return instanceProfileArn;
    }

    /**
     * <p>
     * The Java virtual evn in the Spark EMR properties patch.
     * </p>
     * 
     * @return The Java virtual evn in the Spark EMR properties patch.
     */
    public final String javaVirtualEnv() {
        return javaVirtualEnv;
    }

    /**
     * <p>
     * The log URI in the Spark EMR properties patch.
     * </p>
     * 
     * @return The log URI in the Spark EMR properties patch.
     */
    public final String logUri() {
        return logUri;
    }

    /**
     * <p>
     * The managed endpoint ARN of the EMR on EKS cluster.
     * </p>
     * 
     * @return The managed endpoint ARN of the EMR on EKS cluster.
     */
    public final String managedEndpointArn() {
        return managedEndpointArn;
    }

    /**
     * <p>
     * The Python virtual env in the Spark EMR properties patch.
     * </p>
     * 
     * @return The Python virtual env in the Spark EMR properties patch.
     */
    public final String pythonVirtualEnv() {
        return pythonVirtualEnv;
    }

    /**
     * <p>
     * The runtime role in the Spark EMR properties patch.
     * </p>
     * 
     * @return The runtime role in the Spark EMR properties patch.
     */
    public final String runtimeRole() {
        return runtimeRole;
    }

    /**
     * <p>
     * The trusted certificates S3 URI in the Spark EMR properties patch.
     * </p>
     * 
     * @return The trusted certificates S3 URI in the Spark EMR properties patch.
     */
    public final String trustedCertificatesS3Uri() {
        return trustedCertificatesS3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(javaVirtualEnv());
        hashCode = 31 * hashCode + Objects.hashCode(logUri());
        hashCode = 31 * hashCode + Objects.hashCode(managedEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(pythonVirtualEnv());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeRole());
        hashCode = 31 * hashCode + Objects.hashCode(trustedCertificatesS3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkEmrPropertiesPatch)) {
            return false;
        }
        SparkEmrPropertiesPatch other = (SparkEmrPropertiesPatch) obj;
        return Objects.equals(computeArn(), other.computeArn())
                && Objects.equals(instanceProfileArn(), other.instanceProfileArn())
                && Objects.equals(javaVirtualEnv(), other.javaVirtualEnv()) && Objects.equals(logUri(), other.logUri())
                && Objects.equals(managedEndpointArn(), other.managedEndpointArn())
                && Objects.equals(pythonVirtualEnv(), other.pythonVirtualEnv())
                && Objects.equals(runtimeRole(), other.runtimeRole())
                && Objects.equals(trustedCertificatesS3Uri(), other.trustedCertificatesS3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SparkEmrPropertiesPatch").add("ComputeArn", computeArn())
                .add("InstanceProfileArn", instanceProfileArn()).add("JavaVirtualEnv", javaVirtualEnv()).add("LogUri", logUri())
                .add("ManagedEndpointArn", managedEndpointArn()).add("PythonVirtualEnv", pythonVirtualEnv())
                .add("RuntimeRole", runtimeRole()).add("TrustedCertificatesS3Uri", trustedCertificatesS3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeArn":
            return Optional.ofNullable(clazz.cast(computeArn()));
        case "instanceProfileArn":
            return Optional.ofNullable(clazz.cast(instanceProfileArn()));
        case "javaVirtualEnv":
            return Optional.ofNullable(clazz.cast(javaVirtualEnv()));
        case "logUri":
            return Optional.ofNullable(clazz.cast(logUri()));
        case "managedEndpointArn":
            return Optional.ofNullable(clazz.cast(managedEndpointArn()));
        case "pythonVirtualEnv":
            return Optional.ofNullable(clazz.cast(pythonVirtualEnv()));
        case "runtimeRole":
            return Optional.ofNullable(clazz.cast(runtimeRole()));
        case "trustedCertificatesS3Uri":
            return Optional.ofNullable(clazz.cast(trustedCertificatesS3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computeArn", COMPUTE_ARN_FIELD);
        map.put("instanceProfileArn", INSTANCE_PROFILE_ARN_FIELD);
        map.put("javaVirtualEnv", JAVA_VIRTUAL_ENV_FIELD);
        map.put("logUri", LOG_URI_FIELD);
        map.put("managedEndpointArn", MANAGED_ENDPOINT_ARN_FIELD);
        map.put("pythonVirtualEnv", PYTHON_VIRTUAL_ENV_FIELD);
        map.put("runtimeRole", RUNTIME_ROLE_FIELD);
        map.put("trustedCertificatesS3Uri", TRUSTED_CERTIFICATES_S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkEmrPropertiesPatch, T> g) {
        return obj -> g.apply((SparkEmrPropertiesPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SparkEmrPropertiesPatch> {
        /**
         * <p>
         * The compute ARN in the Spark EMR properties patch.
         * </p>
         * 
         * @param computeArn
         *        The compute ARN in the Spark EMR properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeArn(String computeArn);

        /**
         * <p>
         * The instance profile ARN in the Spark EMR properties patch.
         * </p>
         * 
         * @param instanceProfileArn
         *        The instance profile ARN in the Spark EMR properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileArn(String instanceProfileArn);

        /**
         * <p>
         * The Java virtual evn in the Spark EMR properties patch.
         * </p>
         * 
         * @param javaVirtualEnv
         *        The Java virtual evn in the Spark EMR properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder javaVirtualEnv(String javaVirtualEnv);

        /**
         * <p>
         * The log URI in the Spark EMR properties patch.
         * </p>
         * 
         * @param logUri
         *        The log URI in the Spark EMR properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * The managed endpoint ARN of the EMR on EKS cluster.
         * </p>
         * 
         * @param managedEndpointArn
         *        The managed endpoint ARN of the EMR on EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedEndpointArn(String managedEndpointArn);

        /**
         * <p>
         * The Python virtual env in the Spark EMR properties patch.
         * </p>
         * 
         * @param pythonVirtualEnv
         *        The Python virtual env in the Spark EMR properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonVirtualEnv(String pythonVirtualEnv);

        /**
         * <p>
         * The runtime role in the Spark EMR properties patch.
         * </p>
         * 
         * @param runtimeRole
         *        The runtime role in the Spark EMR properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeRole(String runtimeRole);

        /**
         * <p>
         * The trusted certificates S3 URI in the Spark EMR properties patch.
         * </p>
         * 
         * @param trustedCertificatesS3Uri
         *        The trusted certificates S3 URI in the Spark EMR properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedCertificatesS3Uri(String trustedCertificatesS3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String computeArn;

        private String instanceProfileArn;

        private String javaVirtualEnv;

        private String logUri;

        private String managedEndpointArn;

        private String pythonVirtualEnv;

        private String runtimeRole;

        private String trustedCertificatesS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(SparkEmrPropertiesPatch model) {
            computeArn(model.computeArn);
            instanceProfileArn(model.instanceProfileArn);
            javaVirtualEnv(model.javaVirtualEnv);
            logUri(model.logUri);
            managedEndpointArn(model.managedEndpointArn);
            pythonVirtualEnv(model.pythonVirtualEnv);
            runtimeRole(model.runtimeRole);
            trustedCertificatesS3Uri(model.trustedCertificatesS3Uri);
        }

        public final String getComputeArn() {
            return computeArn;
        }

        public final void setComputeArn(String computeArn) {
            this.computeArn = computeArn;
        }

        @Override
        public final Builder computeArn(String computeArn) {
            this.computeArn = computeArn;
            return this;
        }

        public final String getInstanceProfileArn() {
            return instanceProfileArn;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final String getJavaVirtualEnv() {
            return javaVirtualEnv;
        }

        public final void setJavaVirtualEnv(String javaVirtualEnv) {
            this.javaVirtualEnv = javaVirtualEnv;
        }

        @Override
        public final Builder javaVirtualEnv(String javaVirtualEnv) {
            this.javaVirtualEnv = javaVirtualEnv;
            return this;
        }

        public final String getLogUri() {
            return logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getManagedEndpointArn() {
            return managedEndpointArn;
        }

        public final void setManagedEndpointArn(String managedEndpointArn) {
            this.managedEndpointArn = managedEndpointArn;
        }

        @Override
        public final Builder managedEndpointArn(String managedEndpointArn) {
            this.managedEndpointArn = managedEndpointArn;
            return this;
        }

        public final String getPythonVirtualEnv() {
            return pythonVirtualEnv;
        }

        public final void setPythonVirtualEnv(String pythonVirtualEnv) {
            this.pythonVirtualEnv = pythonVirtualEnv;
        }

        @Override
        public final Builder pythonVirtualEnv(String pythonVirtualEnv) {
            this.pythonVirtualEnv = pythonVirtualEnv;
            return this;
        }

        public final String getRuntimeRole() {
            return runtimeRole;
        }

        public final void setRuntimeRole(String runtimeRole) {
            this.runtimeRole = runtimeRole;
        }

        @Override
        public final Builder runtimeRole(String runtimeRole) {
            this.runtimeRole = runtimeRole;
            return this;
        }

        public final String getTrustedCertificatesS3Uri() {
            return trustedCertificatesS3Uri;
        }

        public final void setTrustedCertificatesS3Uri(String trustedCertificatesS3Uri) {
            this.trustedCertificatesS3Uri = trustedCertificatesS3Uri;
        }

        @Override
        public final Builder trustedCertificatesS3Uri(String trustedCertificatesS3Uri) {
            this.trustedCertificatesS3Uri = trustedCertificatesS3Uri;
            return this;
        }

        @Override
        public SparkEmrPropertiesPatch build() {
            return new SparkEmrPropertiesPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
