/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 properties of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3PropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<S3PropertiesOutput.Builder, S3PropertiesOutput> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(S3PropertiesOutput::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> S3_ACCESS_GRANT_LOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3AccessGrantLocationId").getter(getter(S3PropertiesOutput::s3AccessGrantLocationId))
            .setter(setter(Builder::s3AccessGrantLocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessGrantLocationId").build())
            .build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(S3PropertiesOutput::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(S3PropertiesOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            S3_ACCESS_GRANT_LOCATION_ID_FIELD, S3_URI_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorMessage;

    private final String s3AccessGrantLocationId;

    private final String s3Uri;

    private final String status;

    private S3PropertiesOutput(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.s3AccessGrantLocationId = builder.s3AccessGrantLocationId;
        this.s3Uri = builder.s3Uri;
        this.status = builder.status;
    }

    /**
     * <p>
     * The error message that gets displayed.
     * </p>
     * 
     * @return The error message that gets displayed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The Amazon S3 Access Grant location ID that's part of the Amazon S3 properties of a connection.
     * </p>
     * 
     * @return The Amazon S3 Access Grant location ID that's part of the Amazon S3 properties of a connection.
     */
    public final String s3AccessGrantLocationId() {
        return s3AccessGrantLocationId;
    }

    /**
     * <p>
     * The Amazon S3 URI that's part of the Amazon S3 properties of a connection.
     * </p>
     * 
     * @return The Amazon S3 URI that's part of the Amazon S3 properties of a connection.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The status of the Amazon S3 connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon S3 connection.
     * @see ConnectionStatus
     */
    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon S3 connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon S3 connection.
     * @see ConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessGrantLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3PropertiesOutput)) {
            return false;
        }
        S3PropertiesOutput other = (S3PropertiesOutput) obj;
        return Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(s3AccessGrantLocationId(), other.s3AccessGrantLocationId())
                && Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3PropertiesOutput").add("ErrorMessage", errorMessage())
                .add("S3AccessGrantLocationId", s3AccessGrantLocationId()).add("S3Uri", s3Uri()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "s3AccessGrantLocationId":
            return Optional.ofNullable(clazz.cast(s3AccessGrantLocationId()));
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("s3AccessGrantLocationId", S3_ACCESS_GRANT_LOCATION_ID_FIELD);
        map.put("s3Uri", S3_URI_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3PropertiesOutput, T> g) {
        return obj -> g.apply((S3PropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3PropertiesOutput> {
        /**
         * <p>
         * The error message that gets displayed.
         * </p>
         * 
         * @param errorMessage
         *        The error message that gets displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The Amazon S3 Access Grant location ID that's part of the Amazon S3 properties of a connection.
         * </p>
         * 
         * @param s3AccessGrantLocationId
         *        The Amazon S3 Access Grant location ID that's part of the Amazon S3 properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessGrantLocationId(String s3AccessGrantLocationId);

        /**
         * <p>
         * The Amazon S3 URI that's part of the Amazon S3 properties of a connection.
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 URI that's part of the Amazon S3 properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The status of the Amazon S3 connection.
         * </p>
         * 
         * @param status
         *        The status of the Amazon S3 connection.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon S3 connection.
         * </p>
         * 
         * @param status
         *        The status of the Amazon S3 connection.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(ConnectionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String errorMessage;

        private String s3AccessGrantLocationId;

        private String s3Uri;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(S3PropertiesOutput model) {
            errorMessage(model.errorMessage);
            s3AccessGrantLocationId(model.s3AccessGrantLocationId);
            s3Uri(model.s3Uri);
            status(model.status);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getS3AccessGrantLocationId() {
            return s3AccessGrantLocationId;
        }

        public final void setS3AccessGrantLocationId(String s3AccessGrantLocationId) {
            this.s3AccessGrantLocationId = s3AccessGrantLocationId;
        }

        @Override
        public final Builder s3AccessGrantLocationId(String s3AccessGrantLocationId) {
            this.s3AccessGrantLocationId = s3AccessGrantLocationId;
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public S3PropertiesOutput build() {
            return new S3PropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
