/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of the Amazon Redshift data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftRunConfigurationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftRunConfigurationOutput.Builder, RedshiftRunConfigurationOutput> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(RedshiftRunConfigurationOutput::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessRole").getter(getter(RedshiftRunConfigurationOutput::dataAccessRole))
            .setter(setter(Builder::dataAccessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRole").build()).build();

    private static final SdkField<RedshiftCredentialConfiguration> REDSHIFT_CREDENTIAL_CONFIGURATION_FIELD = SdkField
            .<RedshiftCredentialConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("redshiftCredentialConfiguration")
            .getter(getter(RedshiftRunConfigurationOutput::redshiftCredentialConfiguration))
            .setter(setter(Builder::redshiftCredentialConfiguration))
            .constructor(RedshiftCredentialConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftCredentialConfiguration")
                    .build()).build();

    private static final SdkField<RedshiftStorage> REDSHIFT_STORAGE_FIELD = SdkField
            .<RedshiftStorage> builder(MarshallingType.SDK_POJO).memberName("redshiftStorage")
            .getter(getter(RedshiftRunConfigurationOutput::redshiftStorage)).setter(setter(Builder::redshiftStorage))
            .constructor(RedshiftStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftStorage").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(RedshiftRunConfigurationOutput::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<RelationalFilterConfiguration>> RELATIONAL_FILTER_CONFIGURATIONS_FIELD = SdkField
            .<List<RelationalFilterConfiguration>> builder(MarshallingType.LIST)
            .memberName("relationalFilterConfigurations")
            .getter(getter(RedshiftRunConfigurationOutput::relationalFilterConfigurations))
            .setter(setter(Builder::relationalFilterConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalFilterConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelationalFilterConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelationalFilterConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            DATA_ACCESS_ROLE_FIELD, REDSHIFT_CREDENTIAL_CONFIGURATION_FIELD, REDSHIFT_STORAGE_FIELD, REGION_FIELD,
            RELATIONAL_FILTER_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String dataAccessRole;

    private final RedshiftCredentialConfiguration redshiftCredentialConfiguration;

    private final RedshiftStorage redshiftStorage;

    private final String region;

    private final List<RelationalFilterConfiguration> relationalFilterConfigurations;

    private RedshiftRunConfigurationOutput(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.dataAccessRole = builder.dataAccessRole;
        this.redshiftCredentialConfiguration = builder.redshiftCredentialConfiguration;
        this.redshiftStorage = builder.redshiftStorage;
        this.region = builder.region;
        this.relationalFilterConfigurations = builder.relationalFilterConfigurations;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account included in the configuration details of the Amazon Redshift data
     * source.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account included in the configuration details of the Amazon Redshift
     *         data source.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The data access role included in the configuration details of the Amazon Redshift data source.
     * </p>
     * 
     * @return The data access role included in the configuration details of the Amazon Redshift data source.
     */
    public final String dataAccessRole() {
        return dataAccessRole;
    }

    /**
     * Returns the value of the RedshiftCredentialConfiguration property for this object.
     * 
     * @return The value of the RedshiftCredentialConfiguration property for this object.
     */
    public final RedshiftCredentialConfiguration redshiftCredentialConfiguration() {
        return redshiftCredentialConfiguration;
    }

    /**
     * Returns the value of the RedshiftStorage property for this object.
     * 
     * @return The value of the RedshiftStorage property for this object.
     */
    public final RedshiftStorage redshiftStorage() {
        return redshiftStorage;
    }

    /**
     * <p>
     * The Amazon Web Services region included in the configuration details of the Amazon Redshift data source.
     * </p>
     * 
     * @return The Amazon Web Services region included in the configuration details of the Amazon Redshift data source.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelationalFilterConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRelationalFilterConfigurations() {
        return relationalFilterConfigurations != null && !(relationalFilterConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The relational filger configurations included in the configuration details of the Amazon Redshift data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelationalFilterConfigurations} method.
     * </p>
     * 
     * @return The relational filger configurations included in the configuration details of the Amazon Redshift data
     *         source.
     */
    public final List<RelationalFilterConfiguration> relationalFilterConfigurations() {
        return relationalFilterConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftCredentialConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftStorage());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRelationalFilterConfigurations() ? relationalFilterConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftRunConfigurationOutput)) {
            return false;
        }
        RedshiftRunConfigurationOutput other = (RedshiftRunConfigurationOutput) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(dataAccessRole(), other.dataAccessRole())
                && Objects.equals(redshiftCredentialConfiguration(), other.redshiftCredentialConfiguration())
                && Objects.equals(redshiftStorage(), other.redshiftStorage()) && Objects.equals(region(), other.region())
                && hasRelationalFilterConfigurations() == other.hasRelationalFilterConfigurations()
                && Objects.equals(relationalFilterConfigurations(), other.relationalFilterConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("RedshiftRunConfigurationOutput")
                .add("AccountId", accountId())
                .add("DataAccessRole", dataAccessRole())
                .add("RedshiftCredentialConfiguration", redshiftCredentialConfiguration())
                .add("RedshiftStorage", redshiftStorage())
                .add("Region", region())
                .add("RelationalFilterConfigurations",
                        hasRelationalFilterConfigurations() ? relationalFilterConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "dataAccessRole":
            return Optional.ofNullable(clazz.cast(dataAccessRole()));
        case "redshiftCredentialConfiguration":
            return Optional.ofNullable(clazz.cast(redshiftCredentialConfiguration()));
        case "redshiftStorage":
            return Optional.ofNullable(clazz.cast(redshiftStorage()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "relationalFilterConfigurations":
            return Optional.ofNullable(clazz.cast(relationalFilterConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("dataAccessRole", DATA_ACCESS_ROLE_FIELD);
        map.put("redshiftCredentialConfiguration", REDSHIFT_CREDENTIAL_CONFIGURATION_FIELD);
        map.put("redshiftStorage", REDSHIFT_STORAGE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("relationalFilterConfigurations", RELATIONAL_FILTER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftRunConfigurationOutput, T> g) {
        return obj -> g.apply((RedshiftRunConfigurationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftRunConfigurationOutput> {
        /**
         * <p>
         * The ID of the Amazon Web Services account included in the configuration details of the Amazon Redshift data
         * source.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account included in the configuration details of the Amazon Redshift
         *        data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The data access role included in the configuration details of the Amazon Redshift data source.
         * </p>
         * 
         * @param dataAccessRole
         *        The data access role included in the configuration details of the Amazon Redshift data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRole(String dataAccessRole);

        /**
         * Sets the value of the RedshiftCredentialConfiguration property for this object.
         *
         * @param redshiftCredentialConfiguration
         *        The new value for the RedshiftCredentialConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftCredentialConfiguration(RedshiftCredentialConfiguration redshiftCredentialConfiguration);

        /**
         * Sets the value of the RedshiftCredentialConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RedshiftCredentialConfiguration.Builder}
         * avoiding the need to create one manually via {@link RedshiftCredentialConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftCredentialConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #redshiftCredentialConfiguration(RedshiftCredentialConfiguration)}.
         * 
         * @param redshiftCredentialConfiguration
         *        a consumer that will call methods on {@link RedshiftCredentialConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftCredentialConfiguration(RedshiftCredentialConfiguration)
         */
        default Builder redshiftCredentialConfiguration(
                Consumer<RedshiftCredentialConfiguration.Builder> redshiftCredentialConfiguration) {
            return redshiftCredentialConfiguration(RedshiftCredentialConfiguration.builder()
                    .applyMutation(redshiftCredentialConfiguration).build());
        }

        /**
         * Sets the value of the RedshiftStorage property for this object.
         *
         * @param redshiftStorage
         *        The new value for the RedshiftStorage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftStorage(RedshiftStorage redshiftStorage);

        /**
         * Sets the value of the RedshiftStorage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RedshiftStorage.Builder} avoiding the
         * need to create one manually via {@link RedshiftStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftStorage(RedshiftStorage)}.
         * 
         * @param redshiftStorage
         *        a consumer that will call methods on {@link RedshiftStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftStorage(RedshiftStorage)
         */
        default Builder redshiftStorage(Consumer<RedshiftStorage.Builder> redshiftStorage) {
            return redshiftStorage(RedshiftStorage.builder().applyMutation(redshiftStorage).build());
        }

        /**
         * <p>
         * The Amazon Web Services region included in the configuration details of the Amazon Redshift data source.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services region included in the configuration details of the Amazon Redshift data
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The relational filger configurations included in the configuration details of the Amazon Redshift data
         * source.
         * </p>
         * 
         * @param relationalFilterConfigurations
         *        The relational filger configurations included in the configuration details of the Amazon Redshift data
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalFilterConfigurations(Collection<RelationalFilterConfiguration> relationalFilterConfigurations);

        /**
         * <p>
         * The relational filger configurations included in the configuration details of the Amazon Redshift data
         * source.
         * </p>
         * 
         * @param relationalFilterConfigurations
         *        The relational filger configurations included in the configuration details of the Amazon Redshift data
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalFilterConfigurations(RelationalFilterConfiguration... relationalFilterConfigurations);

        /**
         * <p>
         * The relational filger configurations included in the configuration details of the Amazon Redshift data
         * source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #relationalFilterConfigurations(List<RelationalFilterConfiguration>)}.
         * 
         * @param relationalFilterConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalFilterConfigurations(java.util.Collection<RelationalFilterConfiguration>)
         */
        Builder relationalFilterConfigurations(Consumer<RelationalFilterConfiguration.Builder>... relationalFilterConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String dataAccessRole;

        private RedshiftCredentialConfiguration redshiftCredentialConfiguration;

        private RedshiftStorage redshiftStorage;

        private String region;

        private List<RelationalFilterConfiguration> relationalFilterConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftRunConfigurationOutput model) {
            accountId(model.accountId);
            dataAccessRole(model.dataAccessRole);
            redshiftCredentialConfiguration(model.redshiftCredentialConfiguration);
            redshiftStorage(model.redshiftStorage);
            region(model.region);
            relationalFilterConfigurations(model.relationalFilterConfigurations);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getDataAccessRole() {
            return dataAccessRole;
        }

        public final void setDataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
        }

        @Override
        public final Builder dataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
            return this;
        }

        public final RedshiftCredentialConfiguration.Builder getRedshiftCredentialConfiguration() {
            return redshiftCredentialConfiguration != null ? redshiftCredentialConfiguration.toBuilder() : null;
        }

        public final void setRedshiftCredentialConfiguration(
                RedshiftCredentialConfiguration.BuilderImpl redshiftCredentialConfiguration) {
            this.redshiftCredentialConfiguration = redshiftCredentialConfiguration != null ? redshiftCredentialConfiguration
                    .build() : null;
        }

        @Override
        public final Builder redshiftCredentialConfiguration(RedshiftCredentialConfiguration redshiftCredentialConfiguration) {
            this.redshiftCredentialConfiguration = redshiftCredentialConfiguration;
            return this;
        }

        public final RedshiftStorage.Builder getRedshiftStorage() {
            return redshiftStorage != null ? redshiftStorage.toBuilder() : null;
        }

        public final void setRedshiftStorage(RedshiftStorage.BuilderImpl redshiftStorage) {
            this.redshiftStorage = redshiftStorage != null ? redshiftStorage.build() : null;
        }

        @Override
        public final Builder redshiftStorage(RedshiftStorage redshiftStorage) {
            this.redshiftStorage = redshiftStorage;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<RelationalFilterConfiguration.Builder> getRelationalFilterConfigurations() {
            List<RelationalFilterConfiguration.Builder> result = RelationalFilterConfigurationsCopier
                    .copyToBuilder(this.relationalFilterConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalFilterConfigurations(
                Collection<RelationalFilterConfiguration.BuilderImpl> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier
                    .copyFromBuilder(relationalFilterConfigurations);
        }

        @Override
        public final Builder relationalFilterConfigurations(
                Collection<RelationalFilterConfiguration> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier.copy(relationalFilterConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(RelationalFilterConfiguration... relationalFilterConfigurations) {
            relationalFilterConfigurations(Arrays.asList(relationalFilterConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(
                Consumer<RelationalFilterConfiguration.Builder>... relationalFilterConfigurations) {
            relationalFilterConfigurations(Stream.of(relationalFilterConfigurations)
                    .map(c -> RelationalFilterConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RedshiftRunConfigurationOutput build() {
            return new RedshiftRunConfigurationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
