/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recommendation to be updated as part of the <code>UpdateDataSource</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationConfiguration.Builder, RecommendationConfiguration> {
    private static final SdkField<Boolean> ENABLE_BUSINESS_NAME_GENERATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBusinessNameGeneration")
            .getter(getter(RecommendationConfiguration::enableBusinessNameGeneration))
            .setter(setter(Builder::enableBusinessNameGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBusinessNameGeneration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLE_BUSINESS_NAME_GENERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableBusinessNameGeneration;

    private RecommendationConfiguration(BuilderImpl builder) {
        this.enableBusinessNameGeneration = builder.enableBusinessNameGeneration;
    }

    /**
     * <p>
     * Specifies whether automatic business name generation is to be enabled or not as part of the recommendation
     * configuration.
     * </p>
     * 
     * @return Specifies whether automatic business name generation is to be enabled or not as part of the
     *         recommendation configuration.
     */
    public final Boolean enableBusinessNameGeneration() {
        return enableBusinessNameGeneration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableBusinessNameGeneration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationConfiguration)) {
            return false;
        }
        RecommendationConfiguration other = (RecommendationConfiguration) obj;
        return Objects.equals(enableBusinessNameGeneration(), other.enableBusinessNameGeneration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationConfiguration")
                .add("EnableBusinessNameGeneration", enableBusinessNameGeneration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enableBusinessNameGeneration":
            return Optional.ofNullable(clazz.cast(enableBusinessNameGeneration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enableBusinessNameGeneration", ENABLE_BUSINESS_NAME_GENERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationConfiguration, T> g) {
        return obj -> g.apply((RecommendationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationConfiguration> {
        /**
         * <p>
         * Specifies whether automatic business name generation is to be enabled or not as part of the recommendation
         * configuration.
         * </p>
         * 
         * @param enableBusinessNameGeneration
         *        Specifies whether automatic business name generation is to be enabled or not as part of the
         *        recommendation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBusinessNameGeneration(Boolean enableBusinessNameGeneration);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableBusinessNameGeneration;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationConfiguration model) {
            enableBusinessNameGeneration(model.enableBusinessNameGeneration);
        }

        public final Boolean getEnableBusinessNameGeneration() {
            return enableBusinessNameGeneration;
        }

        public final void setEnableBusinessNameGeneration(Boolean enableBusinessNameGeneration) {
            this.enableBusinessNameGeneration = enableBusinessNameGeneration;
        }

        @Override
        public final Builder enableBusinessNameGeneration(Boolean enableBusinessNameGeneration) {
            this.enableBusinessNameGeneration = enableBusinessNameGeneration;
            return this;
        }

        @Override
        public RecommendationConfiguration build() {
            return new RecommendationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
