/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The statistics of the metadata generation run type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataGenerationRunTypeStat implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataGenerationRunTypeStat.Builder, MetadataGenerationRunTypeStat> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(MetadataGenerationRunTypeStat::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MetadataGenerationRunTypeStat::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(MetadataGenerationRunTypeStat::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorMessage;

    private final String status;

    private final String type;

    private MetadataGenerationRunTypeStat(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The error message displayed if the action fails to run.
     * </p>
     * 
     * @return The error message displayed if the action fails to run.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The status of the metadata generation run type statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetadataGenerationRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the metadata generation run type statistics.
     * @see MetadataGenerationRunStatus
     */
    public final MetadataGenerationRunStatus status() {
        return MetadataGenerationRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the metadata generation run type statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetadataGenerationRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the metadata generation run type statistics.
     * @see MetadataGenerationRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the metadata generation run type statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the metadata generation run type statistics.
     * @see MetadataGenerationRunType
     */
    public final MetadataGenerationRunType type() {
        return MetadataGenerationRunType.fromValue(type);
    }

    /**
     * <p>
     * The type of the metadata generation run type statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the metadata generation run type statistics.
     * @see MetadataGenerationRunType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataGenerationRunTypeStat)) {
            return false;
        }
        MetadataGenerationRunTypeStat other = (MetadataGenerationRunTypeStat) obj;
        return Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataGenerationRunTypeStat").add("ErrorMessage", errorMessage())
                .add("Status", statusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataGenerationRunTypeStat, T> g) {
        return obj -> g.apply((MetadataGenerationRunTypeStat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataGenerationRunTypeStat> {
        /**
         * <p>
         * The error message displayed if the action fails to run.
         * </p>
         * 
         * @param errorMessage
         *        The error message displayed if the action fails to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The status of the metadata generation run type statistics.
         * </p>
         * 
         * @param status
         *        The status of the metadata generation run type statistics.
         * @see MetadataGenerationRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the metadata generation run type statistics.
         * </p>
         * 
         * @param status
         *        The status of the metadata generation run type statistics.
         * @see MetadataGenerationRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunStatus
         */
        Builder status(MetadataGenerationRunStatus status);

        /**
         * <p>
         * The type of the metadata generation run type statistics.
         * </p>
         * 
         * @param type
         *        The type of the metadata generation run type statistics.
         * @see MetadataGenerationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the metadata generation run type statistics.
         * </p>
         * 
         * @param type
         *        The type of the metadata generation run type statistics.
         * @see MetadataGenerationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunType
         */
        Builder type(MetadataGenerationRunType type);
    }

    static final class BuilderImpl implements Builder {
        private String errorMessage;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataGenerationRunTypeStat model) {
            errorMessage(model.errorMessage);
            status(model.status);
            type(model.type);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MetadataGenerationRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataGenerationRunType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public MetadataGenerationRunTypeStat build() {
            return new MetadataGenerationRunTypeStat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
