/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The asset for which metadata was generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataGenerationRunTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataGenerationRunTarget.Builder, MetadataGenerationRunTarget> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(MetadataGenerationRunTarget::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(MetadataGenerationRunTarget::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(MetadataGenerationRunTarget::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            REVISION_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String revision;

    private final String type;

    private MetadataGenerationRunTarget(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.revision = builder.revision;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the metadata generation run's target.
     * </p>
     * 
     * @return The ID of the metadata generation run's target.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The revision of the asset for which metadata was generated.
     * </p>
     * 
     * @return The revision of the asset for which metadata was generated.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The type of the asset for which metadata was generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the asset for which metadata was generated.
     * @see MetadataGenerationTargetType
     */
    public final MetadataGenerationTargetType type() {
        return MetadataGenerationTargetType.fromValue(type);
    }

    /**
     * <p>
     * The type of the asset for which metadata was generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the asset for which metadata was generated.
     * @see MetadataGenerationTargetType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataGenerationRunTarget)) {
            return false;
        }
        MetadataGenerationRunTarget other = (MetadataGenerationRunTarget) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(revision(), other.revision())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataGenerationRunTarget").add("Identifier", identifier()).add("Revision", revision())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataGenerationRunTarget, T> g) {
        return obj -> g.apply((MetadataGenerationRunTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataGenerationRunTarget> {
        /**
         * <p>
         * The ID of the metadata generation run's target.
         * </p>
         * 
         * @param identifier
         *        The ID of the metadata generation run's target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The revision of the asset for which metadata was generated.
         * </p>
         * 
         * @param revision
         *        The revision of the asset for which metadata was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The type of the asset for which metadata was generated.
         * </p>
         * 
         * @param type
         *        The type of the asset for which metadata was generated.
         * @see MetadataGenerationTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationTargetType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the asset for which metadata was generated.
         * </p>
         * 
         * @param type
         *        The type of the asset for which metadata was generated.
         * @see MetadataGenerationTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationTargetType
         */
        Builder type(MetadataGenerationTargetType type);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String revision;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataGenerationRunTarget model) {
            identifier(model.identifier);
            revision(model.revision);
            type(model.type);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataGenerationTargetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public MetadataGenerationRunTarget build() {
            return new MetadataGenerationRunTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
