/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountsInAccountPoolRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListAccountsInAccountPoolRequest.Builder, ListAccountsInAccountPoolRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListAccountsInAccountPoolRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(ListAccountsInAccountPoolRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAccountsInAccountPoolRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccountsInAccountPoolRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final String identifier;

    private final Integer maxResults;

    private final String nextToken;

    private ListAccountsInAccountPoolRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the domain in which the accounts in the specified account pool are to be listed.
     * </p>
     * 
     * @return The ID of the domain in which the accounts in the specified account pool are to be listed.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the account pool whose accounts are to be listed.
     * </p>
     * 
     * @return The ID of the account pool whose accounts are to be listed.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The maximum number of accounts to return in a single call to ListAccountsInAccountPool. When the number of
     * accounts to be listed is greater than the value of MaxResults, the response contains a NextToken value that you
     * can use in a subsequent call to ListAccountsInAccountPool to list the next set of accounts.
     * </p>
     * 
     * @return The maximum number of accounts to return in a single call to ListAccountsInAccountPool. When the number
     *         of accounts to be listed is greater than the value of MaxResults, the response contains a NextToken value
     *         that you can use in a subsequent call to ListAccountsInAccountPool to list the next set of accounts.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of accounts is greater than the default value for the MaxResults parameter, or if you explicitly
     * specify a value for MaxResults that is less than the number of accounts, the response includes a pagination token
     * named NextToken. You can specify this NextToken value in a subsequent call to ListAccountsInAccountPool to list
     * the next set of accounts.
     * </p>
     * 
     * @return When the number of accounts is greater than the default value for the MaxResults parameter, or if you
     *         explicitly specify a value for MaxResults that is less than the number of accounts, the response includes
     *         a pagination token named NextToken. You can specify this NextToken value in a subsequent call to
     *         ListAccountsInAccountPool to list the next set of accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsInAccountPoolRequest)) {
            return false;
        }
        ListAccountsInAccountPoolRequest other = (ListAccountsInAccountPoolRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccountsInAccountPoolRequest").add("DomainIdentifier", domainIdentifier())
                .add("Identifier", identifier()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountsInAccountPoolRequest, T> g) {
        return obj -> g.apply((ListAccountsInAccountPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAccountsInAccountPoolRequest> {
        /**
         * <p>
         * The ID of the domain in which the accounts in the specified account pool are to be listed.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain in which the accounts in the specified account pool are to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the account pool whose accounts are to be listed.
         * </p>
         * 
         * @param identifier
         *        The ID of the account pool whose accounts are to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The maximum number of accounts to return in a single call to ListAccountsInAccountPool. When the number of
         * accounts to be listed is greater than the value of MaxResults, the response contains a NextToken value that
         * you can use in a subsequent call to ListAccountsInAccountPool to list the next set of accounts.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of accounts to return in a single call to ListAccountsInAccountPool. When the
         *        number of accounts to be listed is greater than the value of MaxResults, the response contains a
         *        NextToken value that you can use in a subsequent call to ListAccountsInAccountPool to list the next
         *        set of accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of accounts is greater than the default value for the MaxResults parameter, or if you
         * explicitly specify a value for MaxResults that is less than the number of accounts, the response includes a
         * pagination token named NextToken. You can specify this NextToken value in a subsequent call to
         * ListAccountsInAccountPool to list the next set of accounts.
         * </p>
         * 
         * @param nextToken
         *        When the number of accounts is greater than the default value for the MaxResults parameter, or if you
         *        explicitly specify a value for MaxResults that is less than the number of accounts, the response
         *        includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call
         *        to ListAccountsInAccountPool to list the next set of accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String identifier;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountsInAccountPoolRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountsInAccountPoolRequest build() {
            return new ListAccountsInAccountPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
