/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job run summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobRunSummary implements SdkPojo, Serializable, ToCopyableBuilder<JobRunSummary.Builder, JobRunSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(JobRunSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(JobRunSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(JobRunSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(JobRunSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<JobRunError> ERROR_FIELD = SdkField.<JobRunError> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(JobRunSummary::error)).setter(setter(Builder::error))
            .constructor(JobRunError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(JobRunSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(JobRunSummary::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(JobRunSummary::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> RUN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runMode").getter(getter(JobRunSummary::runModeAsString)).setter(setter(Builder::runMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runMode").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(JobRunSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(JobRunSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DOMAIN_ID_FIELD, END_TIME_FIELD, ERROR_FIELD, JOB_ID_FIELD, JOB_TYPE_FIELD, RUN_ID_FIELD,
            RUN_MODE_FIELD, START_TIME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final String domainId;

    private final Instant endTime;

    private final JobRunError error;

    private final String jobId;

    private final String jobType;

    private final String runId;

    private final String runMode;

    private final Instant startTime;

    private final String status;

    private JobRunSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.endTime = builder.endTime;
        this.error = builder.error;
        this.jobId = builder.jobId;
        this.jobType = builder.jobType;
        this.runId = builder.runId;
        this.runMode = builder.runMode;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The timestamp at which job run was created.
     * </p>
     * 
     * @return The timestamp at which job run was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the job run.
     * </p>
     * 
     * @return The user who created the job run.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The domain ID of the job run.
     * </p>
     * 
     * @return The domain ID of the job run.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The end time of a job run.
     * </p>
     * 
     * @return The end time of a job run.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The error of a job run.
     * </p>
     * 
     * @return The error of a job run.
     */
    public final JobRunError error() {
        return error;
    }

    /**
     * <p>
     * The job ID of a job run.
     * </p>
     * 
     * @return The job ID of a job run.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job type of a job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job type of a job run.
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The job type of a job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job type of a job run.
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The run ID of a job run.
     * </p>
     * 
     * @return The run ID of a job run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The run mode of a job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runMode} will
     * return {@link JobRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runModeAsString}.
     * </p>
     * 
     * @return The run mode of a job run.
     * @see JobRunMode
     */
    public final JobRunMode runMode() {
        return JobRunMode.fromValue(runMode);
    }

    /**
     * <p>
     * The run mode of a job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runMode} will
     * return {@link JobRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runModeAsString}.
     * </p>
     * 
     * @return The run mode of a job run.
     * @see JobRunMode
     */
    public final String runModeAsString() {
        return runMode;
    }

    /**
     * <p>
     * The start time of a job run.
     * </p>
     * 
     * @return The start time of a job run.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of a job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a job run.
     * @see JobRunStatus
     */
    public final JobRunStatus status() {
        return JobRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a job run.
     * @see JobRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(runModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRunSummary)) {
            return false;
        }
        JobRunSummary other = (JobRunSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(error(), other.error()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(runId(), other.runId())
                && Objects.equals(runModeAsString(), other.runModeAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobRunSummary").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("DomainId", domainId()).add("EndTime", endTime()).add("Error", error()).add("JobId", jobId())
                .add("JobType", jobTypeAsString()).add("RunId", runId()).add("RunMode", runModeAsString())
                .add("StartTime", startTime()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "runMode":
            return Optional.ofNullable(clazz.cast(runModeAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobType", JOB_TYPE_FIELD);
        map.put("runId", RUN_ID_FIELD);
        map.put("runMode", RUN_MODE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobRunSummary, T> g) {
        return obj -> g.apply((JobRunSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobRunSummary> {
        /**
         * <p>
         * The timestamp at which job run was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which job run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the job run.
         * </p>
         * 
         * @param createdBy
         *        The user who created the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The domain ID of the job run.
         * </p>
         * 
         * @param domainId
         *        The domain ID of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The end time of a job run.
         * </p>
         * 
         * @param endTime
         *        The end time of a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The error of a job run.
         * </p>
         * 
         * @param error
         *        The error of a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(JobRunError error);

        /**
         * <p>
         * The error of a job run.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobRunError.Builder} avoiding the need to
         * create one manually via {@link JobRunError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobRunError.Builder#build()} is called immediately and its result
         * is passed to {@link #error(JobRunError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link JobRunError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(JobRunError)
         */
        default Builder error(Consumer<JobRunError.Builder> error) {
            return error(JobRunError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The job ID of a job run.
         * </p>
         * 
         * @param jobId
         *        The job ID of a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job type of a job run.
         * </p>
         * 
         * @param jobType
         *        The job type of a job run.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The job type of a job run.
         * </p>
         * 
         * @param jobType
         *        The job type of a job run.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The run ID of a job run.
         * </p>
         * 
         * @param runId
         *        The run ID of a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The run mode of a job run.
         * </p>
         * 
         * @param runMode
         *        The run mode of a job run.
         * @see JobRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunMode
         */
        Builder runMode(String runMode);

        /**
         * <p>
         * The run mode of a job run.
         * </p>
         * 
         * @param runMode
         *        The run mode of a job run.
         * @see JobRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunMode
         */
        Builder runMode(JobRunMode runMode);

        /**
         * <p>
         * The start time of a job run.
         * </p>
         * 
         * @param startTime
         *        The start time of a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of a job run.
         * </p>
         * 
         * @param status
         *        The status of a job run.
         * @see JobRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a job run.
         * </p>
         * 
         * @param status
         *        The status of a job run.
         * @see JobRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunStatus
         */
        Builder status(JobRunStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String domainId;

        private Instant endTime;

        private JobRunError error;

        private String jobId;

        private String jobType;

        private String runId;

        private String runMode;

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRunSummary model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            domainId(model.domainId);
            endTime(model.endTime);
            error(model.error);
            jobId(model.jobId);
            jobType(model.jobType);
            runId(model.runId);
            runMode(model.runMode);
            startTime(model.startTime);
            status(model.status);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final JobRunError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(JobRunError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(JobRunError error) {
            this.error = error;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getRunMode() {
            return runMode;
        }

        public final void setRunMode(String runMode) {
            this.runMode = runMode;
        }

        @Override
        public final Builder runMode(String runMode) {
            this.runMode = runMode;
            return this;
        }

        @Override
        public final Builder runMode(JobRunMode runMode) {
            this.runMode(runMode == null ? null : runMode.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public JobRunSummary build() {
            return new JobRunSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
