/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetadataGenerationRunResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetMetadataGenerationRunResponse.Builder, GetMetadataGenerationRunResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetMetadataGenerationRunResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetMetadataGenerationRunResponse::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetMetadataGenerationRunResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetMetadataGenerationRunResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(GetMetadataGenerationRunResponse::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetMetadataGenerationRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<MetadataGenerationRunTarget> TARGET_FIELD = SdkField
            .<MetadataGenerationRunTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(GetMetadataGenerationRunResponse::target)).setter(setter(Builder::target))
            .constructor(MetadataGenerationRunTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetMetadataGenerationRunResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<MetadataGenerationRunTypeStat>> TYPE_STATS_FIELD = SdkField
            .<List<MetadataGenerationRunTypeStat>> builder(MarshallingType.LIST)
            .memberName("typeStats")
            .getter(getter(GetMetadataGenerationRunResponse::typeStats))
            .setter(setter(Builder::typeStats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeStats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetadataGenerationRunTypeStat> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataGenerationRunTypeStat::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("types")
            .getter(getter(GetMetadataGenerationRunResponse::typesAsStrings))
            .setter(setter(Builder::typesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DOMAIN_ID_FIELD, ID_FIELD, OWNING_PROJECT_ID_FIELD, STATUS_FIELD, TARGET_FIELD, TYPE_FIELD,
            TYPE_STATS_FIELD, TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final String createdBy;

    private final String domainId;

    private final String id;

    private final String owningProjectId;

    private final String status;

    private final MetadataGenerationRunTarget target;

    private final String type;

    private final List<MetadataGenerationRunTypeStat> typeStats;

    private final List<String> types;

    private GetMetadataGenerationRunResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.owningProjectId = builder.owningProjectId;
        this.status = builder.status;
        this.target = builder.target;
        this.type = builder.type;
        this.typeStats = builder.typeStats;
        this.types = builder.types;
    }

    /**
     * <p>
     * The timestamp of when the metadata generation run was start.
     * </p>
     * 
     * @return The timestamp of when the metadata generation run was start.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who started the metadata generation run.
     * </p>
     * 
     * @return The Amazon DataZone user who started the metadata generation run.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain the metadata generation run of which you want to get.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain the metadata generation run of which you want to get.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the metadata generation run.
     * </p>
     * 
     * @return The ID of the metadata generation run.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the project that owns the assets for which you're running metadata generation.
     * </p>
     * 
     * @return The ID of the project that owns the assets for which you're running metadata generation.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    /**
     * <p>
     * The status of the metadata generation run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetadataGenerationRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the metadata generation run.
     * @see MetadataGenerationRunStatus
     */
    public final MetadataGenerationRunStatus status() {
        return MetadataGenerationRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the metadata generation run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MetadataGenerationRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the metadata generation run.
     * @see MetadataGenerationRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The asset for which you're generating metadata.
     * </p>
     * 
     * @return The asset for which you're generating metadata.
     */
    public final MetadataGenerationRunTarget target() {
        return target;
    }

    /**
     * <p>
     * The type of metadata generation run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of metadata generation run.
     * @see MetadataGenerationRunType
     * @deprecated This field is going to be deprecated, please use the 'types' field to provide the
     *             MetadataGenerationRun types
     */
    @Deprecated
    public final MetadataGenerationRunType type() {
        return MetadataGenerationRunType.fromValue(type);
    }

    /**
     * <p>
     * The type of metadata generation run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataGenerationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of metadata generation run.
     * @see MetadataGenerationRunType
     * @deprecated This field is going to be deprecated, please use the 'types' field to provide the
     *             MetadataGenerationRun types
     */
    @Deprecated
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the TypeStats property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTypeStats() {
        return typeStats != null && !(typeStats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type stats included in the metadata generation run output details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypeStats} method.
     * </p>
     * 
     * @return The type stats included in the metadata generation run output details.
     */
    public final List<MetadataGenerationRunTypeStat> typeStats() {
        return typeStats;
    }

    /**
     * <p>
     * The types of the metadata generation run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The types of the metadata generation run.
     */
    public final List<MetadataGenerationRunType> types() {
        return MetadataGenerationRunTypesCopier.copyStringToEnum(types);
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of the metadata generation run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The types of the metadata generation run.
     */
    public final List<String> typesAsStrings() {
        return types;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypeStats() ? typeStats() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? typesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetadataGenerationRunResponse)) {
            return false;
        }
        GetMetadataGenerationRunResponse other = (GetMetadataGenerationRunResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(id(), other.id())
                && Objects.equals(owningProjectId(), other.owningProjectId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(target(), other.target())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasTypeStats() == other.hasTypeStats()
                && Objects.equals(typeStats(), other.typeStats()) && hasTypes() == other.hasTypes()
                && Objects.equals(typesAsStrings(), other.typesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetadataGenerationRunResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("DomainId", domainId()).add("Id", id()).add("OwningProjectId", owningProjectId())
                .add("Status", statusAsString()).add("Target", target()).add("Type", typeAsString())
                .add("TypeStats", hasTypeStats() ? typeStats() : null).add("Types", hasTypes() ? typesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "typeStats":
            return Optional.ofNullable(clazz.cast(typeStats()));
        case "types":
            return Optional.ofNullable(clazz.cast(typesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("typeStats", TYPE_STATS_FIELD);
        map.put("types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetadataGenerationRunResponse, T> g) {
        return obj -> g.apply((GetMetadataGenerationRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMetadataGenerationRunResponse> {
        /**
         * <p>
         * The timestamp of when the metadata generation run was start.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the metadata generation run was start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who started the metadata generation run.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who started the metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The ID of the Amazon DataZone domain the metadata generation run of which you want to get.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain the metadata generation run of which you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the metadata generation run.
         * </p>
         * 
         * @param id
         *        The ID of the metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the project that owns the assets for which you're running metadata generation.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the project that owns the assets for which you're running metadata generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);

        /**
         * <p>
         * The status of the metadata generation run.
         * </p>
         * 
         * @param status
         *        The status of the metadata generation run.
         * @see MetadataGenerationRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the metadata generation run.
         * </p>
         * 
         * @param status
         *        The status of the metadata generation run.
         * @see MetadataGenerationRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunStatus
         */
        Builder status(MetadataGenerationRunStatus status);

        /**
         * <p>
         * The asset for which you're generating metadata.
         * </p>
         * 
         * @param target
         *        The asset for which you're generating metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(MetadataGenerationRunTarget target);

        /**
         * <p>
         * The asset for which you're generating metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataGenerationRunTarget.Builder}
         * avoiding the need to create one manually via {@link MetadataGenerationRunTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataGenerationRunTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(MetadataGenerationRunTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link MetadataGenerationRunTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(MetadataGenerationRunTarget)
         */
        default Builder target(Consumer<MetadataGenerationRunTarget.Builder> target) {
            return target(MetadataGenerationRunTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The type of metadata generation run.
         * </p>
         * 
         * @param type
         *        The type of metadata generation run.
         * @see MetadataGenerationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunType
         * @deprecated This field is going to be deprecated, please use the 'types' field to provide the
         *             MetadataGenerationRun types
         */
        @Deprecated
        Builder type(String type);

        /**
         * <p>
         * The type of metadata generation run.
         * </p>
         * 
         * @param type
         *        The type of metadata generation run.
         * @see MetadataGenerationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataGenerationRunType
         * @deprecated This field is going to be deprecated, please use the 'types' field to provide the
         *             MetadataGenerationRun types
         */
        @Deprecated
        Builder type(MetadataGenerationRunType type);

        /**
         * <p>
         * The type stats included in the metadata generation run output details.
         * </p>
         * 
         * @param typeStats
         *        The type stats included in the metadata generation run output details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeStats(Collection<MetadataGenerationRunTypeStat> typeStats);

        /**
         * <p>
         * The type stats included in the metadata generation run output details.
         * </p>
         * 
         * @param typeStats
         *        The type stats included in the metadata generation run output details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeStats(MetadataGenerationRunTypeStat... typeStats);

        /**
         * <p>
         * The type stats included in the metadata generation run output details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.MetadataGenerationRunTypeStat.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.MetadataGenerationRunTypeStat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.MetadataGenerationRunTypeStat.Builder#build()} is
         * called immediately and its result is passed to {@link #typeStats(List<MetadataGenerationRunTypeStat>)}.
         * 
         * @param typeStats
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.MetadataGenerationRunTypeStat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeStats(java.util.Collection<MetadataGenerationRunTypeStat>)
         */
        Builder typeStats(Consumer<MetadataGenerationRunTypeStat.Builder>... typeStats);

        /**
         * <p>
         * The types of the metadata generation run.
         * </p>
         * 
         * @param types
         *        The types of the metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(Collection<String> types);

        /**
         * <p>
         * The types of the metadata generation run.
         * </p>
         * 
         * @param types
         *        The types of the metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(String... types);

        /**
         * <p>
         * The types of the metadata generation run.
         * </p>
         * 
         * @param types
         *        The types of the metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<MetadataGenerationRunType> types);

        /**
         * <p>
         * The types of the metadata generation run.
         * </p>
         * 
         * @param types
         *        The types of the metadata generation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(MetadataGenerationRunType... types);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String domainId;

        private String id;

        private String owningProjectId;

        private String status;

        private MetadataGenerationRunTarget target;

        private String type;

        private List<MetadataGenerationRunTypeStat> typeStats = DefaultSdkAutoConstructList.getInstance();

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetadataGenerationRunResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            domainId(model.domainId);
            id(model.id);
            owningProjectId(model.owningProjectId);
            status(model.status);
            target(model.target);
            type(model.type);
            typeStats(model.typeStats);
            typesWithStrings(model.types);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MetadataGenerationRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final MetadataGenerationRunTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(MetadataGenerationRunTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(MetadataGenerationRunTarget target) {
            this.target = target;
            return this;
        }

        @Deprecated
        public final String getType() {
            return type;
        }

        @Deprecated
        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Deprecated
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Deprecated
        public final Builder type(MetadataGenerationRunType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<MetadataGenerationRunTypeStat.Builder> getTypeStats() {
            List<MetadataGenerationRunTypeStat.Builder> result = MetadataGenerationRunTypeStatsCopier
                    .copyToBuilder(this.typeStats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTypeStats(Collection<MetadataGenerationRunTypeStat.BuilderImpl> typeStats) {
            this.typeStats = MetadataGenerationRunTypeStatsCopier.copyFromBuilder(typeStats);
        }

        @Override
        public final Builder typeStats(Collection<MetadataGenerationRunTypeStat> typeStats) {
            this.typeStats = MetadataGenerationRunTypeStatsCopier.copy(typeStats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeStats(MetadataGenerationRunTypeStat... typeStats) {
            typeStats(Arrays.asList(typeStats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeStats(Consumer<MetadataGenerationRunTypeStat.Builder>... typeStats) {
            typeStats(Stream.of(typeStats).map(c -> MetadataGenerationRunTypeStat.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = MetadataGenerationRunTypesCopier.copy(types);
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = MetadataGenerationRunTypesCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String... types) {
            typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<MetadataGenerationRunType> types) {
            this.types = MetadataGenerationRunTypesCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(MetadataGenerationRunType... types) {
            types(Arrays.asList(types));
            return this;
        }

        @Override
        public GetMetadataGenerationRunResponse build() {
            return new GetMetadataGenerationRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
