/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataExportConfigurationResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetDataExportConfigurationResponse.Builder, GetDataExportConfigurationResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetDataExportConfigurationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(GetDataExportConfigurationResponse::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<Boolean> IS_EXPORT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isExportEnabled").getter(getter(GetDataExportConfigurationResponse::isExportEnabled))
            .setter(setter(Builder::isExportEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isExportEnabled").build()).build();

    private static final SdkField<String> S3_TABLE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3TableBucketArn").getter(getter(GetDataExportConfigurationResponse::s3TableBucketArn))
            .setter(setter(Builder::s3TableBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3TableBucketArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDataExportConfigurationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetDataExportConfigurationResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, IS_EXPORT_ENABLED_FIELD, S3_TABLE_BUCKET_ARN_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final EncryptionConfiguration encryptionConfiguration;

    private final Boolean isExportEnabled;

    private final String s3TableBucketArn;

    private final String status;

    private final Instant updatedAt;

    private GetDataExportConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.isExportEnabled = builder.isExportEnabled;
        this.s3TableBucketArn = builder.s3TableBucketArn;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The timestamp at which the data export configuration report was created.
     * </p>
     * 
     * @return The timestamp at which the data export configuration report was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The encryption configuration as part of the data export configuration details.
     * </p>
     * 
     * @return The encryption configuration as part of the data export configuration details.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * Specifies whether the export is enabled.
     * </p>
     * 
     * @return Specifies whether the export is enabled.
     */
    public final Boolean isExportEnabled() {
        return isExportEnabled;
    }

    /**
     * <p>
     * The Amazon S3 table bucket ARN as part of the data export configuration details.
     * </p>
     * 
     * @return The Amazon S3 table bucket ARN as part of the data export configuration details.
     */
    public final String s3TableBucketArn() {
        return s3TableBucketArn;
    }

    /**
     * <p>
     * The status of the data export configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data export configuration.
     * @see ConfigurationStatus
     */
    public final ConfigurationStatus status() {
        return ConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data export configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data export configuration.
     * @see ConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp at which the data export configuration report was updated.
     * </p>
     * 
     * @return The timestamp at which the data export configuration report was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(isExportEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(s3TableBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataExportConfigurationResponse)) {
            return false;
        }
        GetDataExportConfigurationResponse other = (GetDataExportConfigurationResponse) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(isExportEnabled(), other.isExportEnabled())
                && Objects.equals(s3TableBucketArn(), other.s3TableBucketArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataExportConfigurationResponse").add("CreatedAt", createdAt())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("IsExportEnabled", isExportEnabled())
                .add("S3TableBucketArn", s3TableBucketArn()).add("Status", statusAsString()).add("UpdatedAt", updatedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "isExportEnabled":
            return Optional.ofNullable(clazz.cast(isExportEnabled()));
        case "s3TableBucketArn":
            return Optional.ofNullable(clazz.cast(s3TableBucketArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("isExportEnabled", IS_EXPORT_ENABLED_FIELD);
        map.put("s3TableBucketArn", S3_TABLE_BUCKET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataExportConfigurationResponse, T> g) {
        return obj -> g.apply((GetDataExportConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataExportConfigurationResponse> {
        /**
         * <p>
         * The timestamp at which the data export configuration report was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the data export configuration report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The encryption configuration as part of the data export configuration details.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration as part of the data export configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration as part of the data export configuration details.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * Specifies whether the export is enabled.
         * </p>
         * 
         * @param isExportEnabled
         *        Specifies whether the export is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isExportEnabled(Boolean isExportEnabled);

        /**
         * <p>
         * The Amazon S3 table bucket ARN as part of the data export configuration details.
         * </p>
         * 
         * @param s3TableBucketArn
         *        The Amazon S3 table bucket ARN as part of the data export configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3TableBucketArn(String s3TableBucketArn);

        /**
         * <p>
         * The status of the data export configuration.
         * </p>
         * 
         * @param status
         *        The status of the data export configuration.
         * @see ConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data export configuration.
         * </p>
         * 
         * @param status
         *        The status of the data export configuration.
         * @see ConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationStatus
         */
        Builder status(ConfigurationStatus status);

        /**
         * <p>
         * The timestamp at which the data export configuration report was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp at which the data export configuration report was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private EncryptionConfiguration encryptionConfiguration;

        private Boolean isExportEnabled;

        private String s3TableBucketArn;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataExportConfigurationResponse model) {
            super(model);
            createdAt(model.createdAt);
            encryptionConfiguration(model.encryptionConfiguration);
            isExportEnabled(model.isExportEnabled);
            s3TableBucketArn(model.s3TableBucketArn);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Boolean getIsExportEnabled() {
            return isExportEnabled;
        }

        public final void setIsExportEnabled(Boolean isExportEnabled) {
            this.isExportEnabled = isExportEnabled;
        }

        @Override
        public final Builder isExportEnabled(Boolean isExportEnabled) {
            this.isExportEnabled = isExportEnabled;
            return this;
        }

        public final String getS3TableBucketArn() {
            return s3TableBucketArn;
        }

        public final void setS3TableBucketArn(String s3TableBucketArn) {
            this.s3TableBucketArn = s3TableBucketArn;
        }

        @Override
        public final Builder s3TableBucketArn(String s3TableBucketArn) {
            this.s3TableBucketArn = s3TableBucketArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDataExportConfigurationResponse build() {
            return new GetDataExportConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
