/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A search filter clause in Amazon DataZone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterClause implements SdkPojo, Serializable, ToCopyableBuilder<FilterClause.Builder, FilterClause> {
    private static final SdkField<List<FilterClause>> AND_FIELD = SdkField
            .<List<FilterClause>> builder(MarshallingType.LIST)
            .memberName("and")
            .getter(getter(FilterClause::and))
            .setter(setter(Builder::and))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterClause> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterClause::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Filter> FILTER_FIELD = SdkField.<Filter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(FilterClause::filter)).setter(setter(Builder::filter)).constructor(Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<List<FilterClause>> OR_FIELD = SdkField
            .<List<FilterClause>> builder(MarshallingType.LIST)
            .memberName("or")
            .getter(getter(FilterClause::or))
            .setter(setter(Builder::or))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("or").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterClause> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterClause::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD, FILTER_FIELD,
            OR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FilterClause> and;

    private final Filter filter;

    private final List<FilterClause> or;

    private final Type type;

    private FilterClause(BuilderImpl builder) {
        this.and = builder.and;
        this.filter = builder.filter;
        this.or = builder.or;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the And property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAnd() {
        return and != null && !(and instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The 'and' search filter clause in Amazon DataZone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnd} method.
     * </p>
     * 
     * @return The 'and' search filter clause in Amazon DataZone.
     */
    public final List<FilterClause> and() {
        return and;
    }

    /**
     * <p>
     * A search filter in Amazon DataZone.
     * </p>
     * 
     * @return A search filter in Amazon DataZone.
     */
    public final Filter filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Or property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOr() {
        return or != null && !(or instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The 'or' search filter clause in Amazon DataZone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOr} method.
     * </p>
     * 
     * @return The 'or' search filter clause in Amazon DataZone.
     */
    public final List<FilterClause> or() {
        return or;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAnd() ? and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasOr() ? or() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterClause)) {
            return false;
        }
        FilterClause other = (FilterClause) obj;
        return hasAnd() == other.hasAnd() && Objects.equals(and(), other.and()) && Objects.equals(filter(), other.filter())
                && hasOr() == other.hasOr() && Objects.equals(or(), other.or());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterClause").add("And", hasAnd() ? and() : null).add("Filter", filter())
                .add("Or", hasOr() ? or() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "and":
            return Optional.ofNullable(clazz.cast(and()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "or":
            return Optional.ofNullable(clazz.cast(or()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #and()} initialized to the given value.
     *
     * <p>
     * The 'and' search filter clause in Amazon DataZone.
     * </p>
     * 
     * @param and
     *        The 'and' search filter clause in Amazon DataZone.
     */
    public static FilterClause fromAnd(List<FilterClause> and) {
        return builder().and(and).build();
    }

    /**
     * Create an instance of this class with {@link #filter()} initialized to the given value.
     *
     * <p>
     * A search filter in Amazon DataZone.
     * </p>
     * 
     * @param filter
     *        A search filter in Amazon DataZone.
     */
    public static FilterClause fromFilter(Filter filter) {
        return builder().filter(filter).build();
    }

    /**
     * Create an instance of this class with {@link #filter()} initialized to the given value.
     *
     * <p>
     * A search filter in Amazon DataZone.
     * </p>
     * 
     * @param filter
     *        A search filter in Amazon DataZone.
     */
    public static FilterClause fromFilter(Consumer<Filter.Builder> filter) {
        Filter.Builder builder = Filter.builder();
        filter.accept(builder);
        return fromFilter(builder.build());
    }

    /**
     * Create an instance of this class with {@link #or()} initialized to the given value.
     *
     * <p>
     * The 'or' search filter clause in Amazon DataZone.
     * </p>
     * 
     * @param or
     *        The 'or' search filter clause in Amazon DataZone.
     */
    public static FilterClause fromOr(List<FilterClause> or) {
        return builder().or(or).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("and", AND_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("or", OR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterClause, T> g) {
        return obj -> g.apply((FilterClause) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterClause> {
        /**
         * <p>
         * The 'and' search filter clause in Amazon DataZone.
         * </p>
         * 
         * @param and
         *        The 'and' search filter clause in Amazon DataZone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Collection<FilterClause> and);

        /**
         * <p>
         * The 'and' search filter clause in Amazon DataZone.
         * </p>
         * 
         * @param and
         *        The 'and' search filter clause in Amazon DataZone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(FilterClause... and);

        /**
         * <p>
         * The 'and' search filter clause in Amazon DataZone.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FilterClause.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FilterClause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FilterClause.Builder#build()} is called immediately and
         * its result is passed to {@link #and(List<FilterClause>)}.
         * 
         * @param and
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FilterClause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(java.util.Collection<FilterClause>)
         */
        Builder and(Consumer<Builder>... and);

        /**
         * <p>
         * A search filter in Amazon DataZone.
         * </p>
         * 
         * @param filter
         *        A search filter in Amazon DataZone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter filter);

        /**
         * <p>
         * A search filter in Amazon DataZone.
         * </p>
         * This is a convenience method that creates an instance of the {@link Filter.Builder} avoiding the need to
         * create one manually via {@link Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filter.Builder#build()} is called immediately and its result is
         * passed to {@link #filter(Filter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Filter)
         */
        default Builder filter(Consumer<Filter.Builder> filter) {
            return filter(Filter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The 'or' search filter clause in Amazon DataZone.
         * </p>
         * 
         * @param or
         *        The 'or' search filter clause in Amazon DataZone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Collection<FilterClause> or);

        /**
         * <p>
         * The 'or' search filter clause in Amazon DataZone.
         * </p>
         * 
         * @param or
         *        The 'or' search filter clause in Amazon DataZone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(FilterClause... or);

        /**
         * <p>
         * The 'or' search filter clause in Amazon DataZone.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FilterClause.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FilterClause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FilterClause.Builder#build()} is called immediately and
         * its result is passed to {@link #or(List<FilterClause>)}.
         * 
         * @param or
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FilterClause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #or(java.util.Collection<FilterClause>)
         */
        Builder or(Consumer<Builder>... or);
    }

    static final class BuilderImpl implements Builder {
        private List<FilterClause> and = DefaultSdkAutoConstructList.getInstance();

        private Filter filter;

        private List<FilterClause> or = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FilterClause model) {
            and(model.and);
            filter(model.filter);
            or(model.or);
        }

        public final List<Builder> getAnd() {
            List<Builder> result = FilterListCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            Object oldValue = this.and;
            this.and = FilterListCopier.copyFromBuilder(and);
            handleUnionValueChange(Type.AND, oldValue, this.and);
        }

        @Override
        public final Builder and(Collection<FilterClause> and) {
            Object oldValue = this.and;
            this.and = FilterListCopier.copy(and);
            handleUnionValueChange(Type.AND, oldValue, this.and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(FilterClause... and) {
            and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder>... and) {
            and(Stream.of(and).map(c -> FilterClause.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Filter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            Object oldValue = this.filter;
            this.filter = filter != null ? filter.build() : null;
            handleUnionValueChange(Type.FILTER, oldValue, this.filter);
        }

        @Override
        public final Builder filter(Filter filter) {
            Object oldValue = this.filter;
            this.filter = filter;
            handleUnionValueChange(Type.FILTER, oldValue, this.filter);
            return this;
        }

        public final List<Builder> getOr() {
            List<Builder> result = FilterListCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            Object oldValue = this.or;
            this.or = FilterListCopier.copyFromBuilder(or);
            handleUnionValueChange(Type.OR, oldValue, this.or);
        }

        @Override
        public final Builder or(Collection<FilterClause> or) {
            Object oldValue = this.or;
            this.or = FilterListCopier.copy(or);
            handleUnionValueChange(Type.OR, oldValue, this.or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(FilterClause... or) {
            or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder>... or) {
            or(Stream.of(or).map(c -> FilterClause.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FilterClause build() {
            return new FilterClause(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FilterClause#type()
     */
    public enum Type {
        AND,

        FILTER,

        OR,

        UNKNOWN_TO_SDK_VERSION
    }
}
