/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The environment configuration user parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentConfigurationUserParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentConfigurationUserParameter.Builder, EnvironmentConfigurationUserParameter> {
    private static final SdkField<String> ENVIRONMENT_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentConfigurationName")
            .getter(getter(EnvironmentConfigurationUserParameter::environmentConfigurationName))
            .setter(setter(Builder::environmentConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentConfigurationName")
                    .build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(EnvironmentConfigurationUserParameter::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<List<EnvironmentParameter>> ENVIRONMENT_PARAMETERS_FIELD = SdkField
            .<List<EnvironmentParameter>> builder(MarshallingType.LIST)
            .memberName("environmentParameters")
            .getter(getter(EnvironmentConfigurationUserParameter::environmentParameters))
            .setter(setter(Builder::environmentParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EnvironmentResolvedAccount> ENVIRONMENT_RESOLVED_ACCOUNT_FIELD = SdkField
            .<EnvironmentResolvedAccount> builder(MarshallingType.SDK_POJO)
            .memberName("environmentResolvedAccount")
            .getter(getter(EnvironmentConfigurationUserParameter::environmentResolvedAccount))
            .setter(setter(Builder::environmentResolvedAccount))
            .constructor(EnvironmentResolvedAccount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentResolvedAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENVIRONMENT_CONFIGURATION_NAME_FIELD, ENVIRONMENT_ID_FIELD, ENVIRONMENT_PARAMETERS_FIELD,
            ENVIRONMENT_RESOLVED_ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String environmentConfigurationName;

    private final String environmentId;

    private final List<EnvironmentParameter> environmentParameters;

    private final EnvironmentResolvedAccount environmentResolvedAccount;

    private EnvironmentConfigurationUserParameter(BuilderImpl builder) {
        this.environmentConfigurationName = builder.environmentConfigurationName;
        this.environmentId = builder.environmentId;
        this.environmentParameters = builder.environmentParameters;
        this.environmentResolvedAccount = builder.environmentResolvedAccount;
    }

    /**
     * <p>
     * The environment configuration name.
     * </p>
     * 
     * @return The environment configuration name.
     */
    public final String environmentConfigurationName() {
        return environmentConfigurationName;
    }

    /**
     * <p>
     * The ID of the environment.
     * </p>
     * 
     * @return The ID of the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnvironmentParameters() {
        return environmentParameters != null && !(environmentParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environment parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentParameters} method.
     * </p>
     * 
     * @return The environment parameters.
     */
    public final List<EnvironmentParameter> environmentParameters() {
        return environmentParameters;
    }

    /**
     * <p>
     * Specifies the account/Region that is to be used during project creation for a particular blueprint.
     * </p>
     * 
     * @return Specifies the account/Region that is to be used during project creation for a particular blueprint.
     */
    public final EnvironmentResolvedAccount environmentResolvedAccount() {
        return environmentResolvedAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(environmentConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentParameters() ? environmentParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environmentResolvedAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfigurationUserParameter)) {
            return false;
        }
        EnvironmentConfigurationUserParameter other = (EnvironmentConfigurationUserParameter) obj;
        return Objects.equals(environmentConfigurationName(), other.environmentConfigurationName())
                && Objects.equals(environmentId(), other.environmentId())
                && hasEnvironmentParameters() == other.hasEnvironmentParameters()
                && Objects.equals(environmentParameters(), other.environmentParameters())
                && Objects.equals(environmentResolvedAccount(), other.environmentResolvedAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EnvironmentConfigurationUserParameter")
                .add("EnvironmentConfigurationName",
                        environmentConfigurationName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentId", environmentId())
                .add("EnvironmentParameters", hasEnvironmentParameters() ? environmentParameters() : null)
                .add("EnvironmentResolvedAccount", environmentResolvedAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentConfigurationName":
            return Optional.ofNullable(clazz.cast(environmentConfigurationName()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "environmentParameters":
            return Optional.ofNullable(clazz.cast(environmentParameters()));
        case "environmentResolvedAccount":
            return Optional.ofNullable(clazz.cast(environmentResolvedAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentConfigurationName", ENVIRONMENT_CONFIGURATION_NAME_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("environmentParameters", ENVIRONMENT_PARAMETERS_FIELD);
        map.put("environmentResolvedAccount", ENVIRONMENT_RESOLVED_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfigurationUserParameter, T> g) {
        return obj -> g.apply((EnvironmentConfigurationUserParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentConfigurationUserParameter> {
        /**
         * <p>
         * The environment configuration name.
         * </p>
         * 
         * @param environmentConfigurationName
         *        The environment configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentConfigurationName(String environmentConfigurationName);

        /**
         * <p>
         * The ID of the environment.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The environment parameters.
         * </p>
         * 
         * @param environmentParameters
         *        The environment parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentParameters(Collection<EnvironmentParameter> environmentParameters);

        /**
         * <p>
         * The environment parameters.
         * </p>
         * 
         * @param environmentParameters
         *        The environment parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentParameters(EnvironmentParameter... environmentParameters);

        /**
         * <p>
         * The environment parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentParameters(List<EnvironmentParameter>)}.
         * 
         * @param environmentParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentParameters(java.util.Collection<EnvironmentParameter>)
         */
        Builder environmentParameters(Consumer<EnvironmentParameter.Builder>... environmentParameters);

        /**
         * <p>
         * Specifies the account/Region that is to be used during project creation for a particular blueprint.
         * </p>
         * 
         * @param environmentResolvedAccount
         *        Specifies the account/Region that is to be used during project creation for a particular blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentResolvedAccount(EnvironmentResolvedAccount environmentResolvedAccount);

        /**
         * <p>
         * Specifies the account/Region that is to be used during project creation for a particular blueprint.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentResolvedAccount.Builder}
         * avoiding the need to create one manually via {@link EnvironmentResolvedAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentResolvedAccount.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentResolvedAccount(EnvironmentResolvedAccount)}.
         * 
         * @param environmentResolvedAccount
         *        a consumer that will call methods on {@link EnvironmentResolvedAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentResolvedAccount(EnvironmentResolvedAccount)
         */
        default Builder environmentResolvedAccount(Consumer<EnvironmentResolvedAccount.Builder> environmentResolvedAccount) {
            return environmentResolvedAccount(EnvironmentResolvedAccount.builder().applyMutation(environmentResolvedAccount)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String environmentConfigurationName;

        private String environmentId;

        private List<EnvironmentParameter> environmentParameters = DefaultSdkAutoConstructList.getInstance();

        private EnvironmentResolvedAccount environmentResolvedAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfigurationUserParameter model) {
            environmentConfigurationName(model.environmentConfigurationName);
            environmentId(model.environmentId);
            environmentParameters(model.environmentParameters);
            environmentResolvedAccount(model.environmentResolvedAccount);
        }

        public final String getEnvironmentConfigurationName() {
            return environmentConfigurationName;
        }

        public final void setEnvironmentConfigurationName(String environmentConfigurationName) {
            this.environmentConfigurationName = environmentConfigurationName;
        }

        @Override
        public final Builder environmentConfigurationName(String environmentConfigurationName) {
            this.environmentConfigurationName = environmentConfigurationName;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final List<EnvironmentParameter.Builder> getEnvironmentParameters() {
            List<EnvironmentParameter.Builder> result = EnvironmentParametersListCopier.copyToBuilder(this.environmentParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentParameters(Collection<EnvironmentParameter.BuilderImpl> environmentParameters) {
            this.environmentParameters = EnvironmentParametersListCopier.copyFromBuilder(environmentParameters);
        }

        @Override
        public final Builder environmentParameters(Collection<EnvironmentParameter> environmentParameters) {
            this.environmentParameters = EnvironmentParametersListCopier.copy(environmentParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(EnvironmentParameter... environmentParameters) {
            environmentParameters(Arrays.asList(environmentParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(Consumer<EnvironmentParameter.Builder>... environmentParameters) {
            environmentParameters(Stream.of(environmentParameters)
                    .map(c -> EnvironmentParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EnvironmentResolvedAccount.Builder getEnvironmentResolvedAccount() {
            return environmentResolvedAccount != null ? environmentResolvedAccount.toBuilder() : null;
        }

        public final void setEnvironmentResolvedAccount(EnvironmentResolvedAccount.BuilderImpl environmentResolvedAccount) {
            this.environmentResolvedAccount = environmentResolvedAccount != null ? environmentResolvedAccount.build() : null;
        }

        @Override
        public final Builder environmentResolvedAccount(EnvironmentResolvedAccount environmentResolvedAccount) {
            this.environmentResolvedAccount = environmentResolvedAccount;
            return this;
        }

        @Override
        public EnvironmentConfigurationUserParameter build() {
            return new EnvironmentConfigurationUserParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
