/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssetRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateAssetRequest.Builder, CreateAssetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAssetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAssetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateAssetRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> EXTERNAL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalIdentifier").getter(getter(CreateAssetRequest::externalIdentifier))
            .setter(setter(Builder::externalIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIdentifier").build())
            .build();

    private static final SdkField<List<FormInput>> FORMS_INPUT_FIELD = SdkField
            .<List<FormInput>> builder(MarshallingType.LIST)
            .memberName("formsInput")
            .getter(getter(CreateAssetRequest::formsInput))
            .setter(setter(Builder::formsInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsInput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(CreateAssetRequest::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAssetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectIdentifier").getter(getter(CreateAssetRequest::owningProjectIdentifier))
            .setter(setter(Builder::owningProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build())
            .build();

    private static final SdkField<PredictionConfiguration> PREDICTION_CONFIGURATION_FIELD = SdkField
            .<PredictionConfiguration> builder(MarshallingType.SDK_POJO).memberName("predictionConfiguration")
            .getter(getter(CreateAssetRequest::predictionConfiguration)).setter(setter(Builder::predictionConfiguration))
            .constructor(PredictionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionConfiguration").build())
            .build();

    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeIdentifier").getter(getter(CreateAssetRequest::typeIdentifier))
            .setter(setter(Builder::typeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()).build();

    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeRevision").getter(getter(CreateAssetRequest::typeRevision)).setter(setter(Builder::typeRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, EXTERNAL_IDENTIFIER_FIELD, FORMS_INPUT_FIELD, GLOSSARY_TERMS_FIELD,
            NAME_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD, PREDICTION_CONFIGURATION_FIELD, TYPE_IDENTIFIER_FIELD,
            TYPE_REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final String domainIdentifier;

    private final String externalIdentifier;

    private final List<FormInput> formsInput;

    private final List<String> glossaryTerms;

    private final String name;

    private final String owningProjectIdentifier;

    private final PredictionConfiguration predictionConfiguration;

    private final String typeIdentifier;

    private final String typeRevision;

    private CreateAssetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.externalIdentifier = builder.externalIdentifier;
        this.formsInput = builder.formsInput;
        this.glossaryTerms = builder.glossaryTerms;
        this.name = builder.name;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.predictionConfiguration = builder.predictionConfiguration;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Asset description.
     * </p>
     * 
     * @return Asset description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Amazon DataZone domain where the asset is created.
     * </p>
     * 
     * @return Amazon DataZone domain where the asset is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The external identifier of the asset.
     * </p>
     * <p>
     * If the value for the <code>externalIdentifier</code> parameter is specified, it must be a unique value.
     * </p>
     * 
     * @return The external identifier of the asset.</p>
     *         <p>
     *         If the value for the <code>externalIdentifier</code> parameter is specified, it must be a unique value.
     */
    public final String externalIdentifier() {
        return externalIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormsInput property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFormsInput() {
        return formsInput != null && !(formsInput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata forms attached to the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormsInput} method.
     * </p>
     * 
     * @return Metadata forms attached to the asset.
     */
    public final List<FormInput> formsInput() {
        return formsInput;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Glossary terms attached to the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return Glossary terms attached to the asset.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * Asset name.
     * </p>
     * 
     * @return Asset name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the project that owns this asset.
     * </p>
     * 
     * @return The unique identifier of the project that owns this asset.
     */
    public final String owningProjectIdentifier() {
        return owningProjectIdentifier;
    }

    /**
     * <p>
     * The configuration of the automatically generated business-friendly metadata for the asset.
     * </p>
     * 
     * @return The configuration of the automatically generated business-friendly metadata for the asset.
     */
    public final PredictionConfiguration predictionConfiguration() {
        return predictionConfiguration;
    }

    /**
     * <p>
     * The unique identifier of this asset's type.
     * </p>
     * 
     * @return The unique identifier of this asset's type.
     */
    public final String typeIdentifier() {
        return typeIdentifier;
    }

    /**
     * <p>
     * The revision of this asset's type.
     * </p>
     * 
     * @return The revision of this asset's type.
     */
    public final String typeRevision() {
        return typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(externalIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormsInput() ? formsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(predictionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetRequest)) {
            return false;
        }
        CreateAssetRequest other = (CreateAssetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(externalIdentifier(), other.externalIdentifier()) && hasFormsInput() == other.hasFormsInput()
                && Objects.equals(formsInput(), other.formsInput()) && hasGlossaryTerms() == other.hasGlossaryTerms()
                && Objects.equals(glossaryTerms(), other.glossaryTerms()) && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectIdentifier(), other.owningProjectIdentifier())
                && Objects.equals(predictionConfiguration(), other.predictionConfiguration())
                && Objects.equals(typeIdentifier(), other.typeIdentifier())
                && Objects.equals(typeRevision(), other.typeRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssetRequest").add("ClientToken", clientToken())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("ExternalIdentifier", externalIdentifier())
                .add("FormsInput", formsInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OwningProjectIdentifier", owningProjectIdentifier())
                .add("PredictionConfiguration", predictionConfiguration()).add("TypeIdentifier", typeIdentifier())
                .add("TypeRevision", typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "externalIdentifier":
            return Optional.ofNullable(clazz.cast(externalIdentifier()));
        case "formsInput":
            return Optional.ofNullable(clazz.cast(formsInput()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectIdentifier":
            return Optional.ofNullable(clazz.cast(owningProjectIdentifier()));
        case "predictionConfiguration":
            return Optional.ofNullable(clazz.cast(predictionConfiguration()));
        case "typeIdentifier":
            return Optional.ofNullable(clazz.cast(typeIdentifier()));
        case "typeRevision":
            return Optional.ofNullable(clazz.cast(typeRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("externalIdentifier", EXTERNAL_IDENTIFIER_FIELD);
        map.put("formsInput", FORMS_INPUT_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectIdentifier", OWNING_PROJECT_IDENTIFIER_FIELD);
        map.put("predictionConfiguration", PREDICTION_CONFIGURATION_FIELD);
        map.put("typeIdentifier", TYPE_IDENTIFIER_FIELD);
        map.put("typeRevision", TYPE_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetRequest, T> g) {
        return obj -> g.apply((CreateAssetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssetRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Asset description.
         * </p>
         * 
         * @param description
         *        Asset description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Amazon DataZone domain where the asset is created.
         * </p>
         * 
         * @param domainIdentifier
         *        Amazon DataZone domain where the asset is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The external identifier of the asset.
         * </p>
         * <p>
         * If the value for the <code>externalIdentifier</code> parameter is specified, it must be a unique value.
         * </p>
         * 
         * @param externalIdentifier
         *        The external identifier of the asset.</p>
         *        <p>
         *        If the value for the <code>externalIdentifier</code> parameter is specified, it must be a unique
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalIdentifier(String externalIdentifier);

        /**
         * <p>
         * Metadata forms attached to the asset.
         * </p>
         * 
         * @param formsInput
         *        Metadata forms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsInput(Collection<FormInput> formsInput);

        /**
         * <p>
         * Metadata forms attached to the asset.
         * </p>
         * 
         * @param formsInput
         *        Metadata forms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsInput(FormInput... formsInput);

        /**
         * <p>
         * Metadata forms attached to the asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder#build()} is called immediately and
         * its result is passed to {@link #formsInput(List<FormInput>)}.
         * 
         * @param formsInput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formsInput(java.util.Collection<FormInput>)
         */
        Builder formsInput(Consumer<FormInput.Builder>... formsInput);

        /**
         * <p>
         * Glossary terms attached to the asset.
         * </p>
         * 
         * @param glossaryTerms
         *        Glossary terms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * Glossary terms attached to the asset.
         * </p>
         * 
         * @param glossaryTerms
         *        Glossary terms attached to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * Asset name.
         * </p>
         * 
         * @param name
         *        Asset name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the project that owns this asset.
         * </p>
         * 
         * @param owningProjectIdentifier
         *        The unique identifier of the project that owns this asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectIdentifier(String owningProjectIdentifier);

        /**
         * <p>
         * The configuration of the automatically generated business-friendly metadata for the asset.
         * </p>
         * 
         * @param predictionConfiguration
         *        The configuration of the automatically generated business-friendly metadata for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionConfiguration(PredictionConfiguration predictionConfiguration);

        /**
         * <p>
         * The configuration of the automatically generated business-friendly metadata for the asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictionConfiguration.Builder} avoiding
         * the need to create one manually via {@link PredictionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #predictionConfiguration(PredictionConfiguration)}.
         * 
         * @param predictionConfiguration
         *        a consumer that will call methods on {@link PredictionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictionConfiguration(PredictionConfiguration)
         */
        default Builder predictionConfiguration(Consumer<PredictionConfiguration.Builder> predictionConfiguration) {
            return predictionConfiguration(PredictionConfiguration.builder().applyMutation(predictionConfiguration).build());
        }

        /**
         * <p>
         * The unique identifier of this asset's type.
         * </p>
         * 
         * @param typeIdentifier
         *        The unique identifier of this asset's type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeIdentifier(String typeIdentifier);

        /**
         * <p>
         * The revision of this asset's type.
         * </p>
         * 
         * @param typeRevision
         *        The revision of this asset's type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRevision(String typeRevision);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String domainIdentifier;

        private String externalIdentifier;

        private List<FormInput> formsInput = DefaultSdkAutoConstructList.getInstance();

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String owningProjectIdentifier;

        private PredictionConfiguration predictionConfiguration;

        private String typeIdentifier;

        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            externalIdentifier(model.externalIdentifier);
            formsInput(model.formsInput);
            glossaryTerms(model.glossaryTerms);
            name(model.name);
            owningProjectIdentifier(model.owningProjectIdentifier);
            predictionConfiguration(model.predictionConfiguration);
            typeIdentifier(model.typeIdentifier);
            typeRevision(model.typeRevision);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getExternalIdentifier() {
            return externalIdentifier;
        }

        public final void setExternalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
        }

        @Override
        public final Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            return this;
        }

        public final List<FormInput.Builder> getFormsInput() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.formsInput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsInput(Collection<FormInput.BuilderImpl> formsInput) {
            this.formsInput = FormInputListCopier.copyFromBuilder(formsInput);
        }

        @Override
        public final Builder formsInput(Collection<FormInput> formsInput) {
            this.formsInput = FormInputListCopier.copy(formsInput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsInput(FormInput... formsInput) {
            formsInput(Arrays.asList(formsInput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsInput(Consumer<FormInput.Builder>... formsInput) {
            formsInput(Stream.of(formsInput).map(c -> FormInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final PredictionConfiguration.Builder getPredictionConfiguration() {
            return predictionConfiguration != null ? predictionConfiguration.toBuilder() : null;
        }

        public final void setPredictionConfiguration(PredictionConfiguration.BuilderImpl predictionConfiguration) {
            this.predictionConfiguration = predictionConfiguration != null ? predictionConfiguration.build() : null;
        }

        @Override
        public final Builder predictionConfiguration(PredictionConfiguration predictionConfiguration) {
            this.predictionConfiguration = predictionConfiguration;
            return this;
        }

        public final String getTypeIdentifier() {
            return typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetRequest build() {
            return new CreateAssetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
