/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAttributesMetadataResponse extends DataZoneResponse implements
        ToCopyableBuilder<BatchGetAttributesMetadataResponse.Builder, BatchGetAttributesMetadataResponse> {
    private static final SdkField<List<BatchGetAttributeOutput>> ATTRIBUTES_FIELD = SdkField
            .<List<BatchGetAttributeOutput>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(BatchGetAttributesMetadataResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetAttributeOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetAttributeOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttributeError>> ERRORS_FIELD = SdkField
            .<List<AttributeError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetAttributesMetadataResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ATTRIBUTES_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchGetAttributeOutput> attributes;

    private final List<AttributeError> errors;

    private BatchGetAttributesMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the BatchGetAttributesMetadata action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The results of the BatchGetAttributesMetadata action.
     */
    public final List<BatchGetAttributeOutput> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors generated when the BatchGetAttributesMetadata action is invoked.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return The errors generated when the BatchGetAttributesMetadata action is invoked.
     */
    public final List<AttributeError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttributesMetadataResponse)) {
            return false;
        }
        BatchGetAttributesMetadataResponse other = (BatchGetAttributesMetadataResponse) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAttributesMetadataResponse").add("Attributes", hasAttributes() ? attributes() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAttributesMetadataResponse, T> g) {
        return obj -> g.apply((BatchGetAttributesMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAttributesMetadataResponse> {
        /**
         * <p>
         * The results of the BatchGetAttributesMetadata action.
         * </p>
         * 
         * @param attributes
         *        The results of the BatchGetAttributesMetadata action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<BatchGetAttributeOutput> attributes);

        /**
         * <p>
         * The results of the BatchGetAttributesMetadata action.
         * </p>
         * 
         * @param attributes
         *        The results of the BatchGetAttributesMetadata action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(BatchGetAttributeOutput... attributes);

        /**
         * <p>
         * The results of the BatchGetAttributesMetadata action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.BatchGetAttributeOutput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.BatchGetAttributeOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.BatchGetAttributeOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<BatchGetAttributeOutput>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.BatchGetAttributeOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<BatchGetAttributeOutput>)
         */
        Builder attributes(Consumer<BatchGetAttributeOutput.Builder>... attributes);

        /**
         * <p>
         * The errors generated when the BatchGetAttributesMetadata action is invoked.
         * </p>
         * 
         * @param errors
         *        The errors generated when the BatchGetAttributesMetadata action is invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<AttributeError> errors);

        /**
         * <p>
         * The errors generated when the BatchGetAttributesMetadata action is invoked.
         * </p>
         * 
         * @param errors
         *        The errors generated when the BatchGetAttributesMetadata action is invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(AttributeError... errors);

        /**
         * <p>
         * The errors generated when the BatchGetAttributesMetadata action is invoked.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.AttributeError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.AttributeError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.AttributeError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<AttributeError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.AttributeError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<AttributeError>)
         */
        Builder errors(Consumer<AttributeError.Builder>... errors);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private List<BatchGetAttributeOutput> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<AttributeError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAttributesMetadataResponse model) {
            super(model);
            attributes(model.attributes);
            errors(model.errors);
        }

        public final List<BatchGetAttributeOutput.Builder> getAttributes() {
            List<BatchGetAttributeOutput.Builder> result = BatchGetAttributeItemsCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<BatchGetAttributeOutput.BuilderImpl> attributes) {
            this.attributes = BatchGetAttributeItemsCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<BatchGetAttributeOutput> attributes) {
            this.attributes = BatchGetAttributeItemsCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(BatchGetAttributeOutput... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<BatchGetAttributeOutput.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> BatchGetAttributeOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AttributeError.Builder> getErrors() {
            List<AttributeError.Builder> result = AttributesErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AttributeError.BuilderImpl> errors) {
            this.errors = AttributesErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AttributeError> errors) {
            this.errors = AttributesErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AttributeError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AttributeError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> AttributeError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetAttributesMetadataResponse build() {
            return new BatchGetAttributesMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
