/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of a project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLocation implements SdkPojo, Serializable, ToCopyableBuilder<AwsLocation.Builder, AwsLocation> {
    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessRole").getter(getter(AwsLocation::accessRole)).setter(setter(Builder::accessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessRole").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(AwsLocation::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsRegion").getter(getter(AwsLocation::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()).build();

    private static final SdkField<String> IAM_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamConnectionId").getter(getter(AwsLocation::iamConnectionId)).setter(setter(Builder::iamConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamConnectionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_ROLE_FIELD,
            AWS_ACCOUNT_ID_FIELD, AWS_REGION_FIELD, IAM_CONNECTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessRole;

    private final String awsAccountId;

    private final String awsRegion;

    private final String iamConnectionId;

    private AwsLocation(BuilderImpl builder) {
        this.accessRole = builder.accessRole;
        this.awsAccountId = builder.awsAccountId;
        this.awsRegion = builder.awsRegion;
        this.iamConnectionId = builder.iamConnectionId;
    }

    /**
     * <p>
     * The access role of a connection.
     * </p>
     * 
     * @return The access role of a connection.
     */
    public final String accessRole() {
        return accessRole;
    }

    /**
     * <p>
     * The account ID of a connection.
     * </p>
     * 
     * @return The account ID of a connection.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Region of a connection.
     * </p>
     * 
     * @return The Region of a connection.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The IAM connection ID of a connection.
     * </p>
     * 
     * @return The IAM connection ID of a connection.
     */
    public final String iamConnectionId() {
        return iamConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(iamConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLocation)) {
            return false;
        }
        AwsLocation other = (AwsLocation) obj;
        return Objects.equals(accessRole(), other.accessRole()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsRegion(), other.awsRegion()) && Objects.equals(iamConnectionId(), other.iamConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsLocation").add("AccessRole", accessRole()).add("AwsAccountId", awsAccountId())
                .add("AwsRegion", awsRegion()).add("IamConnectionId", iamConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessRole":
            return Optional.ofNullable(clazz.cast(accessRole()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "iamConnectionId":
            return Optional.ofNullable(clazz.cast(iamConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessRole", ACCESS_ROLE_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("iamConnectionId", IAM_CONNECTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLocation, T> g) {
        return obj -> g.apply((AwsLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLocation> {
        /**
         * <p>
         * The access role of a connection.
         * </p>
         * 
         * @param accessRole
         *        The access role of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRole(String accessRole);

        /**
         * <p>
         * The account ID of a connection.
         * </p>
         * 
         * @param awsAccountId
         *        The account ID of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Region of a connection.
         * </p>
         * 
         * @param awsRegion
         *        The Region of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The IAM connection ID of a connection.
         * </p>
         * 
         * @param iamConnectionId
         *        The IAM connection ID of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamConnectionId(String iamConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private String accessRole;

        private String awsAccountId;

        private String awsRegion;

        private String iamConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLocation model) {
            accessRole(model.accessRole);
            awsAccountId(model.awsAccountId);
            awsRegion(model.awsRegion);
            iamConnectionId(model.iamConnectionId);
        }

        public final String getAccessRole() {
            return accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getIamConnectionId() {
            return iamConnectionId;
        }

        public final void setIamConnectionId(String iamConnectionId) {
            this.iamConnectionId = iamConnectionId;
        }

        @Override
        public final Builder iamConnectionId(String iamConnectionId) {
            this.iamConnectionId = iamConnectionId;
            return this;
        }

        @Override
        public AwsLocation build() {
            return new AwsLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
