/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Q properties of the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonQPropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonQPropertiesOutput.Builder, AmazonQPropertiesOutput> {
    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authMode").getter(getter(AmazonQPropertiesOutput::authMode)).setter(setter(Builder::authMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authMode").build()).build();

    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isEnabled").getter(getter(AmazonQPropertiesOutput::isEnabled)).setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEnabled").build()).build();

    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileArn").getter(getter(AmazonQPropertiesOutput::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_MODE_FIELD,
            IS_ENABLED_FIELD, PROFILE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authMode;

    private final Boolean isEnabled;

    private final String profileArn;

    private AmazonQPropertiesOutput(BuilderImpl builder) {
        this.authMode = builder.authMode;
        this.isEnabled = builder.isEnabled;
        this.profileArn = builder.profileArn;
    }

    /**
     * <p>
     * The authentication mode of the connection's Amazon Q properties.
     * </p>
     * 
     * @return The authentication mode of the connection's Amazon Q properties.
     */
    public final String authMode() {
        return authMode;
    }

    /**
     * <p>
     * Specifies whether Amazon Q is enabled for the connection.
     * </p>
     * 
     * @return Specifies whether Amazon Q is enabled for the connection.
     */
    public final Boolean isEnabled() {
        return isEnabled;
    }

    /**
     * <p>
     * The profile ARN of the connection's Amazon Q properties.
     * </p>
     * 
     * @return The profile ARN of the connection's Amazon Q properties.
     */
    public final String profileArn() {
        return profileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authMode());
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonQPropertiesOutput)) {
            return false;
        }
        AmazonQPropertiesOutput other = (AmazonQPropertiesOutput) obj;
        return Objects.equals(authMode(), other.authMode()) && Objects.equals(isEnabled(), other.isEnabled())
                && Objects.equals(profileArn(), other.profileArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonQPropertiesOutput").add("AuthMode", authMode()).add("IsEnabled", isEnabled())
                .add("ProfileArn", profileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authMode":
            return Optional.ofNullable(clazz.cast(authMode()));
        case "isEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        case "profileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authMode", AUTH_MODE_FIELD);
        map.put("isEnabled", IS_ENABLED_FIELD);
        map.put("profileArn", PROFILE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonQPropertiesOutput, T> g) {
        return obj -> g.apply((AmazonQPropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonQPropertiesOutput> {
        /**
         * <p>
         * The authentication mode of the connection's Amazon Q properties.
         * </p>
         * 
         * @param authMode
         *        The authentication mode of the connection's Amazon Q properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authMode(String authMode);

        /**
         * <p>
         * Specifies whether Amazon Q is enabled for the connection.
         * </p>
         * 
         * @param isEnabled
         *        Specifies whether Amazon Q is enabled for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);

        /**
         * <p>
         * The profile ARN of the connection's Amazon Q properties.
         * </p>
         * 
         * @param profileArn
         *        The profile ARN of the connection's Amazon Q properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);
    }

    static final class BuilderImpl implements Builder {
        private String authMode;

        private Boolean isEnabled;

        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonQPropertiesOutput model) {
            authMode(model.authMode);
            isEnabled(model.isEnabled);
            profileArn(model.profileArn);
        }

        public final String getAuthMode() {
            return authMode;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        @Override
        public AmazonQPropertiesOutput build() {
            return new AmazonQPropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
