/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregation for an attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationOutput.Builder, AggregationOutput> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attribute").getter(getter(AggregationOutput::attribute)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<String> DISPLAY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayValue").getter(getter(AggregationOutput::displayValue)).setter(setter(Builder::displayValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayValue").build()).build();

    private static final SdkField<List<AggregationOutputItem>> ITEMS_FIELD = SdkField
            .<List<AggregationOutputItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(AggregationOutput::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregationOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregationOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            DISPLAY_VALUE_FIELD, ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final String displayValue;

    private final List<AggregationOutputItem> items;

    private AggregationOutput(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.displayValue = builder.displayValue;
        this.items = builder.items;
    }

    /**
     * <p>
     * The attribute for this aggregation.
     * </p>
     * 
     * @return The attribute for this aggregation.
     */
    public final String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The display value of the aggregation output item.
     * </p>
     * 
     * @return The display value of the aggregation output item.
     */
    public final String displayValue() {
        return displayValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of aggregation output items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return A list of aggregation output items.
     */
    public final List<AggregationOutputItem> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(displayValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationOutput)) {
            return false;
        }
        AggregationOutput other = (AggregationOutput) obj;
        return Objects.equals(attribute(), other.attribute()) && Objects.equals(displayValue(), other.displayValue())
                && hasItems() == other.hasItems() && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationOutput").add("Attribute", attribute()).add("DisplayValue", displayValue())
                .add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "displayValue":
            return Optional.ofNullable(clazz.cast(displayValue()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attribute", ATTRIBUTE_FIELD);
        map.put("displayValue", DISPLAY_VALUE_FIELD);
        map.put("items", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationOutput, T> g) {
        return obj -> g.apply((AggregationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationOutput> {
        /**
         * <p>
         * The attribute for this aggregation.
         * </p>
         * 
         * @param attribute
         *        The attribute for this aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The display value of the aggregation output item.
         * </p>
         * 
         * @param displayValue
         *        The display value of the aggregation output item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayValue(String displayValue);

        /**
         * <p>
         * A list of aggregation output items.
         * </p>
         * 
         * @param items
         *        A list of aggregation output items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<AggregationOutputItem> items);

        /**
         * <p>
         * A list of aggregation output items.
         * </p>
         * 
         * @param items
         *        A list of aggregation output items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(AggregationOutputItem... items);

        /**
         * <p>
         * A list of aggregation output items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.AggregationOutputItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.AggregationOutputItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.AggregationOutputItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<AggregationOutputItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.AggregationOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<AggregationOutputItem>)
         */
        Builder items(Consumer<AggregationOutputItem.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String displayValue;

        private List<AggregationOutputItem> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationOutput model) {
            attribute(model.attribute);
            displayValue(model.displayValue);
            items(model.items);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getDisplayValue() {
            return displayValue;
        }

        public final void setDisplayValue(String displayValue) {
            this.displayValue = displayValue;
        }

        @Override
        public final Builder displayValue(String displayValue) {
            this.displayValue = displayValue;
            return this;
        }

        public final List<AggregationOutputItem.Builder> getItems() {
            List<AggregationOutputItem.Builder> result = AggregationOutputItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AggregationOutputItem.BuilderImpl> items) {
            this.items = AggregationOutputItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AggregationOutputItem> items) {
            this.items = AggregationOutputItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AggregationOutputItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AggregationOutputItem.Builder>... items) {
            items(Stream.of(items).map(c -> AggregationOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AggregationOutput build() {
            return new AggregationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
