/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The accepted asset scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptedAssetScope implements SdkPojo, Serializable,
        ToCopyableBuilder<AcceptedAssetScope.Builder, AcceptedAssetScope> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(AcceptedAssetScope::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<List<String>> FILTER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("filterIds")
            .getter(getter(AcceptedAssetScope::filterIds))
            .setter(setter(Builder::filterIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            FILTER_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final List<String> filterIds;

    private AcceptedAssetScope(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.filterIds = builder.filterIds;
    }

    /**
     * <p>
     * The asset ID of the accepted asset scope.
     * </p>
     * 
     * @return The asset ID of the accepted asset scope.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilterIds() {
        return filterIds != null && !(filterIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter IDs of the accepted asset scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterIds} method.
     * </p>
     * 
     * @return The filter IDs of the accepted asset scope.
     */
    public final List<String> filterIds() {
        return filterIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterIds() ? filterIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptedAssetScope)) {
            return false;
        }
        AcceptedAssetScope other = (AcceptedAssetScope) obj;
        return Objects.equals(assetId(), other.assetId()) && hasFilterIds() == other.hasFilterIds()
                && Objects.equals(filterIds(), other.filterIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptedAssetScope").add("AssetId", assetId())
                .add("FilterIds", hasFilterIds() ? filterIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "filterIds":
            return Optional.ofNullable(clazz.cast(filterIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("filterIds", FILTER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptedAssetScope, T> g) {
        return obj -> g.apply((AcceptedAssetScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceptedAssetScope> {
        /**
         * <p>
         * The asset ID of the accepted asset scope.
         * </p>
         * 
         * @param assetId
         *        The asset ID of the accepted asset scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The filter IDs of the accepted asset scope.
         * </p>
         * 
         * @param filterIds
         *        The filter IDs of the accepted asset scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterIds(Collection<String> filterIds);

        /**
         * <p>
         * The filter IDs of the accepted asset scope.
         * </p>
         * 
         * @param filterIds
         *        The filter IDs of the accepted asset scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterIds(String... filterIds);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private List<String> filterIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptedAssetScope model) {
            assetId(model.assetId);
            filterIds(model.filterIds);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final Collection<String> getFilterIds() {
            if (filterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return filterIds;
        }

        public final void setFilterIds(Collection<String> filterIds) {
            this.filterIds = FilterIdsCopier.copy(filterIds);
        }

        @Override
        public final Builder filterIds(Collection<String> filterIds) {
            this.filterIds = FilterIdsCopier.copy(filterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterIds(String... filterIds) {
            filterIds(Arrays.asList(filterIds));
            return this;
        }

        @Override
        public AcceptedAssetScope build() {
            return new AcceptedAssetScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
