/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a column
 * name) that can be accepted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptChoice implements SdkPojo, Serializable, ToCopyableBuilder<AcceptChoice.Builder, AcceptChoice> {
    private static final SdkField<String> EDITED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("editedValue").getter(getter(AcceptChoice::editedValue)).setter(setter(Builder::editedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("editedValue").build()).build();

    private static final SdkField<Integer> PREDICTION_CHOICE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("predictionChoice").getter(getter(AcceptChoice::predictionChoice))
            .setter(setter(Builder::predictionChoice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionChoice").build()).build();

    private static final SdkField<String> PREDICTION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("predictionTarget").getter(getter(AcceptChoice::predictionTarget))
            .setter(setter(Builder::predictionTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITED_VALUE_FIELD,
            PREDICTION_CHOICE_FIELD, PREDICTION_TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String editedValue;

    private final Integer predictionChoice;

    private final String predictionTarget;

    private AcceptChoice(BuilderImpl builder) {
        this.editedValue = builder.editedValue;
        this.predictionChoice = builder.predictionChoice;
        this.predictionTarget = builder.predictionTarget;
    }

    /**
     * <p>
     * The edit of the prediction.
     * </p>
     * 
     * @return The edit of the prediction.
     */
    public final String editedValue() {
        return editedValue;
    }

    /**
     * <p>
     * Specifies the prediction (aka, the automatically generated piece of metadata) that can be accepted.
     * </p>
     * 
     * @return Specifies the prediction (aka, the automatically generated piece of metadata) that can be accepted.
     */
    public final Integer predictionChoice() {
        return predictionChoice;
    }

    /**
     * <p>
     * Specifies the target (for example, a column name) where a prediction can be accepted.
     * </p>
     * 
     * @return Specifies the target (for example, a column name) where a prediction can be accepted.
     */
    public final String predictionTarget() {
        return predictionTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(editedValue());
        hashCode = 31 * hashCode + Objects.hashCode(predictionChoice());
        hashCode = 31 * hashCode + Objects.hashCode(predictionTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptChoice)) {
            return false;
        }
        AcceptChoice other = (AcceptChoice) obj;
        return Objects.equals(editedValue(), other.editedValue()) && Objects.equals(predictionChoice(), other.predictionChoice())
                && Objects.equals(predictionTarget(), other.predictionTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptChoice")
                .add("EditedValue", editedValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PredictionChoice", predictionChoice()).add("PredictionTarget", predictionTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "editedValue":
            return Optional.ofNullable(clazz.cast(editedValue()));
        case "predictionChoice":
            return Optional.ofNullable(clazz.cast(predictionChoice()));
        case "predictionTarget":
            return Optional.ofNullable(clazz.cast(predictionTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("editedValue", EDITED_VALUE_FIELD);
        map.put("predictionChoice", PREDICTION_CHOICE_FIELD);
        map.put("predictionTarget", PREDICTION_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptChoice, T> g) {
        return obj -> g.apply((AcceptChoice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceptChoice> {
        /**
         * <p>
         * The edit of the prediction.
         * </p>
         * 
         * @param editedValue
         *        The edit of the prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder editedValue(String editedValue);

        /**
         * <p>
         * Specifies the prediction (aka, the automatically generated piece of metadata) that can be accepted.
         * </p>
         * 
         * @param predictionChoice
         *        Specifies the prediction (aka, the automatically generated piece of metadata) that can be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionChoice(Integer predictionChoice);

        /**
         * <p>
         * Specifies the target (for example, a column name) where a prediction can be accepted.
         * </p>
         * 
         * @param predictionTarget
         *        Specifies the target (for example, a column name) where a prediction can be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionTarget(String predictionTarget);
    }

    static final class BuilderImpl implements Builder {
        private String editedValue;

        private Integer predictionChoice;

        private String predictionTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptChoice model) {
            editedValue(model.editedValue);
            predictionChoice(model.predictionChoice);
            predictionTarget(model.predictionTarget);
        }

        public final String getEditedValue() {
            return editedValue;
        }

        public final void setEditedValue(String editedValue) {
            this.editedValue = editedValue;
        }

        @Override
        public final Builder editedValue(String editedValue) {
            this.editedValue = editedValue;
            return this;
        }

        public final Integer getPredictionChoice() {
            return predictionChoice;
        }

        public final void setPredictionChoice(Integer predictionChoice) {
            this.predictionChoice = predictionChoice;
        }

        @Override
        public final Builder predictionChoice(Integer predictionChoice) {
            this.predictionChoice = predictionChoice;
            return this;
        }

        public final String getPredictionTarget() {
            return predictionTarget;
        }

        public final void setPredictionTarget(String predictionTarget) {
            this.predictionTarget = predictionTarget;
        }

        @Override
        public final Builder predictionTarget(String predictionTarget) {
            this.predictionTarget = predictionTarget;
            return this;
        }

        @Override
        public AcceptChoice build() {
            return new AcceptChoice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
