/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.MemberDetails;
import software.amazon.awssdk.services.datazone.model.UserDesignation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectMember> {
    private static final SdkField<String> DESIGNATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("designation").getter(ProjectMember.getter(ProjectMember::designationAsString)).setter(ProjectMember.setter(Builder::designation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("designation").build()}).build();
    private static final SdkField<MemberDetails> MEMBER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memberDetails").getter(ProjectMember.getter(ProjectMember::memberDetails)).setter(ProjectMember.setter(Builder::memberDetails)).constructor(MemberDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIGNATION_FIELD, MEMBER_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String designation;
    private final MemberDetails memberDetails;

    private ProjectMember(BuilderImpl builder) {
        this.designation = builder.designation;
        this.memberDetails = builder.memberDetails;
    }

    public final UserDesignation designation() {
        return UserDesignation.fromValue(this.designation);
    }

    public final String designationAsString() {
        return this.designation;
    }

    public final MemberDetails memberDetails() {
        return this.memberDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.designationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectMember)) {
            return false;
        }
        ProjectMember other = (ProjectMember)obj;
        return Objects.equals(this.designationAsString(), other.designationAsString()) && Objects.equals(this.memberDetails(), other.memberDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectMember").add("Designation", (Object)this.designationAsString()).add("MemberDetails", (Object)this.memberDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "designation": {
                return Optional.ofNullable(clazz.cast(this.designationAsString()));
            }
            case "memberDetails": {
                return Optional.ofNullable(clazz.cast(this.memberDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("designation", DESIGNATION_FIELD);
        map.put("memberDetails", MEMBER_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectMember, T> g) {
        return obj -> g.apply((ProjectMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String designation;
        private MemberDetails memberDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectMember model) {
            this.designation(model.designation);
            this.memberDetails(model.memberDetails);
        }

        public final String getDesignation() {
            return this.designation;
        }

        public final void setDesignation(String designation) {
            this.designation = designation;
        }

        @Override
        public final Builder designation(String designation) {
            this.designation = designation;
            return this;
        }

        @Override
        public final Builder designation(UserDesignation designation) {
            this.designation(designation == null ? null : designation.toString());
            return this;
        }

        public final MemberDetails.Builder getMemberDetails() {
            return this.memberDetails != null ? this.memberDetails.toBuilder() : null;
        }

        public final void setMemberDetails(MemberDetails.BuilderImpl memberDetails) {
            this.memberDetails = memberDetails != null ? memberDetails.build() : null;
        }

        @Override
        public final Builder memberDetails(MemberDetails memberDetails) {
            this.memberDetails = memberDetails;
            return this;
        }

        public ProjectMember build() {
            return new ProjectMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectMember> {
        public Builder designation(String var1);

        public Builder designation(UserDesignation var1);

        public Builder memberDetails(MemberDetails var1);

        default public Builder memberDetails(Consumer<MemberDetails.Builder> memberDetails) {
            return this.memberDetails((MemberDetails)((MemberDetails.Builder)MemberDetails.builder().applyMutation(memberDetails)).build());
        }
    }
}

