/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.FilterIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptedAssetScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AcceptedAssetScope> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(AcceptedAssetScope.getter(AcceptedAssetScope::assetId)).setter(AcceptedAssetScope.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<List<String>> FILTER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterIds").getter(AcceptedAssetScope.getter(AcceptedAssetScope::filterIds)).setter(AcceptedAssetScope.setter(Builder::filterIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, FILTER_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AcceptedAssetScope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final List<String> filterIds;

    private AcceptedAssetScope(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.filterIds = builder.filterIds;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final boolean hasFilterIds() {
        return this.filterIds != null && !(this.filterIds instanceof SdkAutoConstructList);
    }

    public final List<String> filterIds() {
        return this.filterIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterIds() ? this.filterIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptedAssetScope)) {
            return false;
        }
        AcceptedAssetScope other = (AcceptedAssetScope)obj;
        return Objects.equals(this.assetId(), other.assetId()) && this.hasFilterIds() == other.hasFilterIds() && Objects.equals(this.filterIds(), other.filterIds());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptedAssetScope").add("AssetId", (Object)this.assetId()).add("FilterIds", this.hasFilterIds() ? this.filterIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "filterIds": {
                return Optional.ofNullable(clazz.cast(this.filterIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("filterIds", FILTER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptedAssetScope, T> g) {
        return obj -> g.apply((AcceptedAssetScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private List<String> filterIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptedAssetScope model) {
            this.assetId(model.assetId);
            this.filterIds(model.filterIds);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final Collection<String> getFilterIds() {
            if (this.filterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterIds;
        }

        public final void setFilterIds(Collection<String> filterIds) {
            this.filterIds = FilterIdsCopier.copy(filterIds);
        }

        @Override
        public final Builder filterIds(Collection<String> filterIds) {
            this.filterIds = FilterIdsCopier.copy(filterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterIds(String ... filterIds) {
            this.filterIds(Arrays.asList(filterIds));
            return this;
        }

        public AcceptedAssetScope build() {
            return new AcceptedAssetScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AcceptedAssetScope> {
        public Builder assetId(String var1);

        public Builder filterIds(Collection<String> var1);

        public Builder filterIds(String ... var1);
    }
}

