/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.FormOutput;
import software.amazon.awssdk.services.datazone.model.FormOutputListCopier;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetItemAdditionalAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetItemAdditionalAttributes> {
    private static final SdkField<List<FormOutput>> FORMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("formsOutput").getter(AssetItemAdditionalAttributes.getter(AssetItemAdditionalAttributes::formsOutput)).setter(AssetItemAdditionalAttributes.setter(Builder::formsOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TimeSeriesDataPointSummaryFormOutput>> LATEST_TIME_SERIES_DATA_POINT_FORMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("latestTimeSeriesDataPointFormsOutput").getter(AssetItemAdditionalAttributes.getter(AssetItemAdditionalAttributes::latestTimeSeriesDataPointFormsOutput)).setter(AssetItemAdditionalAttributes.setter(Builder::latestTimeSeriesDataPointFormsOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestTimeSeriesDataPointFormsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesDataPointSummaryFormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FormOutput>> READ_ONLY_FORMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("readOnlyFormsOutput").getter(AssetItemAdditionalAttributes.getter(AssetItemAdditionalAttributes::readOnlyFormsOutput)).setter(AssetItemAdditionalAttributes.setter(Builder::readOnlyFormsOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnlyFormsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMS_OUTPUT_FIELD, LATEST_TIME_SERIES_DATA_POINT_FORMS_OUTPUT_FIELD, READ_ONLY_FORMS_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("formsOutput", FORMS_OUTPUT_FIELD);
            this.put("latestTimeSeriesDataPointFormsOutput", LATEST_TIME_SERIES_DATA_POINT_FORMS_OUTPUT_FIELD);
            this.put("readOnlyFormsOutput", READ_ONLY_FORMS_OUTPUT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<FormOutput> formsOutput;
    private final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointFormsOutput;
    private final List<FormOutput> readOnlyFormsOutput;

    private AssetItemAdditionalAttributes(BuilderImpl builder) {
        this.formsOutput = builder.formsOutput;
        this.latestTimeSeriesDataPointFormsOutput = builder.latestTimeSeriesDataPointFormsOutput;
        this.readOnlyFormsOutput = builder.readOnlyFormsOutput;
    }

    public final boolean hasFormsOutput() {
        return this.formsOutput != null && !(this.formsOutput instanceof SdkAutoConstructList);
    }

    public final List<FormOutput> formsOutput() {
        return this.formsOutput;
    }

    public final boolean hasLatestTimeSeriesDataPointFormsOutput() {
        return this.latestTimeSeriesDataPointFormsOutput != null && !(this.latestTimeSeriesDataPointFormsOutput instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointFormsOutput() {
        return this.latestTimeSeriesDataPointFormsOutput;
    }

    public final boolean hasReadOnlyFormsOutput() {
        return this.readOnlyFormsOutput != null && !(this.readOnlyFormsOutput instanceof SdkAutoConstructList);
    }

    public final List<FormOutput> readOnlyFormsOutput() {
        return this.readOnlyFormsOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsOutput() ? this.formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLatestTimeSeriesDataPointFormsOutput() ? this.latestTimeSeriesDataPointFormsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadOnlyFormsOutput() ? this.readOnlyFormsOutput() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetItemAdditionalAttributes)) {
            return false;
        }
        AssetItemAdditionalAttributes other = (AssetItemAdditionalAttributes)obj;
        return this.hasFormsOutput() == other.hasFormsOutput() && Objects.equals(this.formsOutput(), other.formsOutput()) && this.hasLatestTimeSeriesDataPointFormsOutput() == other.hasLatestTimeSeriesDataPointFormsOutput() && Objects.equals(this.latestTimeSeriesDataPointFormsOutput(), other.latestTimeSeriesDataPointFormsOutput()) && this.hasReadOnlyFormsOutput() == other.hasReadOnlyFormsOutput() && Objects.equals(this.readOnlyFormsOutput(), other.readOnlyFormsOutput());
    }

    public final String toString() {
        return ToString.builder((String)"AssetItemAdditionalAttributes").add("FormsOutput", this.hasFormsOutput() ? this.formsOutput() : null).add("LatestTimeSeriesDataPointFormsOutput", this.hasLatestTimeSeriesDataPointFormsOutput() ? this.latestTimeSeriesDataPointFormsOutput() : null).add("ReadOnlyFormsOutput", this.hasReadOnlyFormsOutput() ? this.readOnlyFormsOutput() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "formsOutput": {
                return Optional.ofNullable(clazz.cast(this.formsOutput()));
            }
            case "latestTimeSeriesDataPointFormsOutput": {
                return Optional.ofNullable(clazz.cast(this.latestTimeSeriesDataPointFormsOutput()));
            }
            case "readOnlyFormsOutput": {
                return Optional.ofNullable(clazz.cast(this.readOnlyFormsOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetItemAdditionalAttributes, T> g) {
        return obj -> g.apply((AssetItemAdditionalAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FormOutput> formsOutput = DefaultSdkAutoConstructList.getInstance();
        private List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointFormsOutput = DefaultSdkAutoConstructList.getInstance();
        private List<FormOutput> readOnlyFormsOutput = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetItemAdditionalAttributes model) {
            this.formsOutput(model.formsOutput);
            this.latestTimeSeriesDataPointFormsOutput(model.latestTimeSeriesDataPointFormsOutput);
            this.readOnlyFormsOutput(model.readOnlyFormsOutput);
        }

        public final List<FormOutput.Builder> getFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Collection<FormOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormOutputListCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Collection<FormOutput> formsOutput) {
            this.formsOutput = FormOutputListCopier.copy(formsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(FormOutput ... formsOutput) {
            this.formsOutput(Arrays.asList(formsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(Consumer<FormOutput.Builder> ... formsOutput) {
            this.formsOutput(Stream.of(formsOutput).map(c -> (FormOutput)((FormOutput.Builder)FormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TimeSeriesDataPointSummaryFormOutput.Builder> getLatestTimeSeriesDataPointFormsOutput() {
            List<TimeSeriesDataPointSummaryFormOutput.Builder> result = TimeSeriesDataPointSummaryFormOutputListCopier.copyToBuilder(this.latestTimeSeriesDataPointFormsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestTimeSeriesDataPointFormsOutput(Collection<TimeSeriesDataPointSummaryFormOutput.BuilderImpl> latestTimeSeriesDataPointFormsOutput) {
            this.latestTimeSeriesDataPointFormsOutput = TimeSeriesDataPointSummaryFormOutputListCopier.copyFromBuilder(latestTimeSeriesDataPointFormsOutput);
        }

        @Override
        public final Builder latestTimeSeriesDataPointFormsOutput(Collection<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointFormsOutput) {
            this.latestTimeSeriesDataPointFormsOutput = TimeSeriesDataPointSummaryFormOutputListCopier.copy(latestTimeSeriesDataPointFormsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointFormsOutput(TimeSeriesDataPointSummaryFormOutput ... latestTimeSeriesDataPointFormsOutput) {
            this.latestTimeSeriesDataPointFormsOutput(Arrays.asList(latestTimeSeriesDataPointFormsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointFormsOutput(Consumer<TimeSeriesDataPointSummaryFormOutput.Builder> ... latestTimeSeriesDataPointFormsOutput) {
            this.latestTimeSeriesDataPointFormsOutput(Stream.of(latestTimeSeriesDataPointFormsOutput).map(c -> (TimeSeriesDataPointSummaryFormOutput)((TimeSeriesDataPointSummaryFormOutput.Builder)TimeSeriesDataPointSummaryFormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FormOutput.Builder> getReadOnlyFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.readOnlyFormsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadOnlyFormsOutput(Collection<FormOutput.BuilderImpl> readOnlyFormsOutput) {
            this.readOnlyFormsOutput = FormOutputListCopier.copyFromBuilder(readOnlyFormsOutput);
        }

        @Override
        public final Builder readOnlyFormsOutput(Collection<FormOutput> readOnlyFormsOutput) {
            this.readOnlyFormsOutput = FormOutputListCopier.copy(readOnlyFormsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFormsOutput(FormOutput ... readOnlyFormsOutput) {
            this.readOnlyFormsOutput(Arrays.asList(readOnlyFormsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFormsOutput(Consumer<FormOutput.Builder> ... readOnlyFormsOutput) {
            this.readOnlyFormsOutput(Stream.of(readOnlyFormsOutput).map(c -> (FormOutput)((FormOutput.Builder)FormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssetItemAdditionalAttributes build() {
            return new AssetItemAdditionalAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetItemAdditionalAttributes> {
        public Builder formsOutput(Collection<FormOutput> var1);

        public Builder formsOutput(FormOutput ... var1);

        public Builder formsOutput(Consumer<FormOutput.Builder> ... var1);

        public Builder latestTimeSeriesDataPointFormsOutput(Collection<TimeSeriesDataPointSummaryFormOutput> var1);

        public Builder latestTimeSeriesDataPointFormsOutput(TimeSeriesDataPointSummaryFormOutput ... var1);

        public Builder latestTimeSeriesDataPointFormsOutput(Consumer<TimeSeriesDataPointSummaryFormOutput.Builder> ... var1);

        public Builder readOnlyFormsOutput(Collection<FormOutput> var1);

        public Builder readOnlyFormsOutput(FormOutput ... var1);

        public Builder readOnlyFormsOutput(Consumer<FormOutput.Builder> ... var1);
    }
}

