/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.BasicAuthenticationCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationConfigurationPatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationConfigurationPatch> {
    private static final SdkField<BasicAuthenticationCredentials> BASIC_AUTHENTICATION_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("basicAuthenticationCredentials").getter(AuthenticationConfigurationPatch.getter(AuthenticationConfigurationPatch::basicAuthenticationCredentials)).setter(AuthenticationConfigurationPatch.setter(Builder::basicAuthenticationCredentials)).constructor(BasicAuthenticationCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthenticationCredentials").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretArn").getter(AuthenticationConfigurationPatch.getter(AuthenticationConfigurationPatch::secretArn)).setter(AuthenticationConfigurationPatch.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTHENTICATION_CREDENTIALS_FIELD, SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("basicAuthenticationCredentials", BASIC_AUTHENTICATION_CREDENTIALS_FIELD);
            this.put("secretArn", SECRET_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BasicAuthenticationCredentials basicAuthenticationCredentials;
    private final String secretArn;

    private AuthenticationConfigurationPatch(BuilderImpl builder) {
        this.basicAuthenticationCredentials = builder.basicAuthenticationCredentials;
        this.secretArn = builder.secretArn;
    }

    public final BasicAuthenticationCredentials basicAuthenticationCredentials() {
        return this.basicAuthenticationCredentials;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthenticationCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfigurationPatch)) {
            return false;
        }
        AuthenticationConfigurationPatch other = (AuthenticationConfigurationPatch)obj;
        return Objects.equals(this.basicAuthenticationCredentials(), other.basicAuthenticationCredentials()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationConfigurationPatch").add("BasicAuthenticationCredentials", (Object)(this.basicAuthenticationCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("SecretArn", (Object)this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "basicAuthenticationCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthenticationCredentials()));
            }
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfigurationPatch, T> g) {
        return obj -> g.apply((AuthenticationConfigurationPatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BasicAuthenticationCredentials basicAuthenticationCredentials;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfigurationPatch model) {
            this.basicAuthenticationCredentials(model.basicAuthenticationCredentials);
            this.secretArn(model.secretArn);
        }

        public final BasicAuthenticationCredentials.Builder getBasicAuthenticationCredentials() {
            return this.basicAuthenticationCredentials != null ? this.basicAuthenticationCredentials.toBuilder() : null;
        }

        public final void setBasicAuthenticationCredentials(BasicAuthenticationCredentials.BuilderImpl basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials != null ? basicAuthenticationCredentials.build() : null;
        }

        @Override
        public final Builder basicAuthenticationCredentials(BasicAuthenticationCredentials basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public AuthenticationConfigurationPatch build() {
            return new AuthenticationConfigurationPatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationConfigurationPatch> {
        public Builder basicAuthenticationCredentials(BasicAuthenticationCredentials var1);

        default public Builder basicAuthenticationCredentials(Consumer<BasicAuthenticationCredentials.Builder> basicAuthenticationCredentials) {
            return this.basicAuthenticationCredentials((BasicAuthenticationCredentials)((BasicAuthenticationCredentials.Builder)BasicAuthenticationCredentials.builder().applyMutation(basicAuthenticationCredentials)).build());
        }

        public Builder secretArn(String var1);
    }
}

