/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AuthenticationType;
import software.amazon.awssdk.services.datazone.model.OAuth2Properties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationConfiguration> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationType").getter(AuthenticationConfiguration.getter(AuthenticationConfiguration::authenticationTypeAsString)).setter(AuthenticationConfiguration.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<OAuth2Properties> O_AUTH2_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuth2Properties").getter(AuthenticationConfiguration.getter(AuthenticationConfiguration::oAuth2Properties)).setter(AuthenticationConfiguration.setter(Builder::oAuth2Properties)).constructor(OAuth2Properties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Properties").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretArn").getter(AuthenticationConfiguration.getter(AuthenticationConfiguration::secretArn)).setter(AuthenticationConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, O_AUTH2_PROPERTIES_FIELD, SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
            this.put("oAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
            this.put("secretArn", SECRET_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final OAuth2Properties oAuth2Properties;
    private final String secretArn;

    private AuthenticationConfiguration(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.oAuth2Properties = builder.oAuth2Properties;
        this.secretArn = builder.secretArn;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final OAuth2Properties oAuth2Properties() {
        return this.oAuth2Properties;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2Properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration other = (AuthenticationConfiguration)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.oAuth2Properties(), other.oAuth2Properties()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationConfiguration").add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("OAuth2Properties", (Object)this.oAuth2Properties()).add("SecretArn", (Object)this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "oAuth2Properties": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Properties()));
            }
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfiguration, T> g) {
        return obj -> g.apply((AuthenticationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private OAuth2Properties oAuth2Properties;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfiguration model) {
            this.authenticationType(model.authenticationType);
            this.oAuth2Properties(model.oAuth2Properties);
            this.secretArn(model.secretArn);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final OAuth2Properties.Builder getOAuth2Properties() {
            return this.oAuth2Properties != null ? this.oAuth2Properties.toBuilder() : null;
        }

        public final void setOAuth2Properties(OAuth2Properties.BuilderImpl oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties != null ? oAuth2Properties.build() : null;
        }

        @Override
        public final Builder oAuth2Properties(OAuth2Properties oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public AuthenticationConfiguration build() {
            return new AuthenticationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationConfiguration> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder oAuth2Properties(OAuth2Properties var1);

        default public Builder oAuth2Properties(Consumer<OAuth2Properties.Builder> oAuth2Properties) {
            return this.oAuth2Properties((OAuth2Properties)((OAuth2Properties.Builder)OAuth2Properties.builder().applyMutation(oAuth2Properties)).build());
        }

        public Builder secretArn(String var1);
    }
}

