/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.MetadataMapCopier;
import software.amazon.awssdk.services.datazone.model.NotificationType;
import software.amazon.awssdk.services.datazone.model.TaskStatus;
import software.amazon.awssdk.services.datazone.model.Topic;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationOutput> {
    private static final SdkField<String> ACTION_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionLink").getter(NotificationOutput.getter(NotificationOutput::actionLink)).setter(NotificationOutput.setter(Builder::actionLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionLink").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(NotificationOutput.getter(NotificationOutput::creationTimestamp)).setter(NotificationOutput.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(NotificationOutput.getter(NotificationOutput::domainIdentifier)).setter(NotificationOutput.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(NotificationOutput.getter(NotificationOutput::identifier)).setter(NotificationOutput.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTimestamp").getter(NotificationOutput.getter(NotificationOutput::lastUpdatedTimestamp)).setter(NotificationOutput.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(NotificationOutput.getter(NotificationOutput::message)).setter(NotificationOutput.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(NotificationOutput.getter(NotificationOutput::metadata)).setter(NotificationOutput.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(NotificationOutput.getter(NotificationOutput::statusAsString)).setter(NotificationOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(NotificationOutput.getter(NotificationOutput::title)).setter(NotificationOutput.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<Topic> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topic").getter(NotificationOutput.getter(NotificationOutput::topic)).setter(NotificationOutput.setter(Builder::topic)).constructor(Topic::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(NotificationOutput.getter(NotificationOutput::typeAsString)).setter(NotificationOutput.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_LINK_FIELD, CREATION_TIMESTAMP_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, MESSAGE_FIELD, METADATA_FIELD, STATUS_FIELD, TITLE_FIELD, TOPIC_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionLink", ACTION_LINK_FIELD);
            this.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("lastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
            this.put("message", MESSAGE_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("topic", TOPIC_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String actionLink;
    private final Instant creationTimestamp;
    private final String domainIdentifier;
    private final String identifier;
    private final Instant lastUpdatedTimestamp;
    private final String message;
    private final Map<String, String> metadata;
    private final String status;
    private final String title;
    private final Topic topic;
    private final String type;

    private NotificationOutput(BuilderImpl builder) {
        this.actionLink = builder.actionLink;
        this.creationTimestamp = builder.creationTimestamp;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.message = builder.message;
        this.metadata = builder.metadata;
        this.status = builder.status;
        this.title = builder.title;
        this.topic = builder.topic;
        this.type = builder.type;
    }

    public final String actionLink() {
        return this.actionLink;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final TaskStatus status() {
        return TaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String title() {
        return this.title;
    }

    public final Topic topic() {
        return this.topic;
    }

    public final NotificationType type() {
        return NotificationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationOutput)) {
            return false;
        }
        NotificationOutput other = (NotificationOutput)obj;
        return Objects.equals(this.actionLink(), other.actionLink()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.message(), other.message()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.topic(), other.topic()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationOutput").add("ActionLink", (Object)(this.actionLink() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationTimestamp", (Object)this.creationTimestamp()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Identifier", (Object)this.identifier()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("Status", (Object)this.statusAsString()).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("Topic", (Object)this.topic()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionLink": {
                return Optional.ofNullable(clazz.cast(this.actionLink()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "lastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NotificationOutput, T> g) {
        return obj -> g.apply((NotificationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionLink;
        private Instant creationTimestamp;
        private String domainIdentifier;
        private String identifier;
        private Instant lastUpdatedTimestamp;
        private String message;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private String title;
        private Topic topic;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationOutput model) {
            this.actionLink(model.actionLink);
            this.creationTimestamp(model.creationTimestamp);
            this.domainIdentifier(model.domainIdentifier);
            this.identifier(model.identifier);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.message(model.message);
            this.metadata(model.metadata);
            this.status(model.status);
            this.title(model.title);
            this.topic(model.topic);
            this.type(model.type);
        }

        public final String getActionLink() {
            return this.actionLink;
        }

        public final void setActionLink(String actionLink) {
            this.actionLink = actionLink;
        }

        @Override
        public final Builder actionLink(String actionLink) {
            this.actionLink = actionLink;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataMapCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataMapCopier.copy(metadata);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Topic.Builder getTopic() {
            return this.topic != null ? this.topic.toBuilder() : null;
        }

        public final void setTopic(Topic.BuilderImpl topic) {
            this.topic = topic != null ? topic.build() : null;
        }

        @Override
        public final Builder topic(Topic topic) {
            this.topic = topic;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public NotificationOutput build() {
            return new NotificationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationOutput> {
        public Builder actionLink(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder domainIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder message(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(TaskStatus var1);

        public Builder title(String var1);

        public Builder topic(Topic var1);

        default public Builder topic(Consumer<Topic.Builder> topic) {
            return this.topic((Topic)((Topic.Builder)Topic.builder().applyMutation(topic)).build());
        }

        public Builder type(String var1);

        public Builder type(NotificationType var1);
    }
}

